# 报警状态
WARNING_FOCUS = 0
WARNING_IGNORE = 1
WARNING_ORDER = 2

PRODUCT = {
    1: "知电U+",
    2: "安电U+",
    4: "识电U+",
    6: "智电U+",
    8: "扬尘",
}

PID_NAME = {
    1: "zhidianu",
    2: "andianu",
    4: "shidianu",
    6: "intelligent-u",
    8: "YangChen",
}

ORDER_STATE = {
    1: "待接单",
    2: "处理中",
    3: "已关闭",
}

# 工单状态
ORDER_ON = 1
ORDER_WORKING = 2
ORDER_CLOSE = 3

# 运维报警
W_ORIGIN_AUTO = 0
W_ORIGIN_MANU = 1

# 报警类型  工单类型
ERROR_TYPE = {
    1: "丢失",
    2: "延迟",
    3: "异常",
    4: "手动"
}
ERROR_TYPE_MANU = 4
SCOPE_DATABASE = "poweriot_point_1min_event"
POINT_1MIN_SCOPE = "poweriot_point_1min_scope"

# event_type映射
EVENT_TYPE_MAP = {
    "overI": "过流",
    "overPR": "负载率越限",
    "overResidualCurrent": "漏电流越限",
    "overTemp": "温度越限",
    "overTempRange1min": "温升1分越限",
    "overTempRange15min": "温升15分越限",
    "overTempTrendDaily": "温度日前预警",
    "overTempTrendQuarterly": "温度实时预警",
    "overTHDI": "电流总谐波有效值越限",
    "overTHDU": "电压总谐波畸变率越限",
    "overU": "过压",
    "unbalanceI": "三相电流不平衡度",
    "unbalanceU": "三相电压不平衡度",
    "underPhasePF": "某相功率因数越下限",
    "underTotalPF": "总功率因数越下限",
    "underU": "欠压",
    "under_rms_u": "电压越下限",
    "over_gap_u": "电压波动",
    "over_rms_u": "电压越上限",
    "over_gap_i": "电流波动",
    "over_rms_i": "电流越限",
}


PHYSICAL = {
    "u": "电压",
    "i": "电流",
    "freq": "频率",
    "pttl": "有功功率",
    "qttl": "无功功率",
    "sttl": "视在功率",
    "costtl": "功率因数",
    "ph": "相角",
    "u_dev": "电压偏差",
    "freq_dev": "频率偏差",
    "ubl": "电压三相不平衡度",
    "ibl": "电流三相不平衡度",
    "thdu": "电压谐波畸变率",
    "thdi": "电流谐波畸变率",
    "fdie": "电流谐波有效值",
}

FILE_KEY = {
    "uab": "Uab(V)", "ucb": "Ucb(V)", "ua": "Ua(V)", "ub": "Ub(V)",
    "uc": "Uc(V)", "ia": "Ia(A)", "ib": "Ib(A)", "ic": "Ic(A)",
    "uab_dev": "Uab电压偏差(V)", "ucb_dev": "Ucb电压偏差(V)", "freq": "频率(Hz)",
    "ua_dev": "Ua电压偏差(V)", "ub_dev": "Ub电压偏差(V)", "uc_dev": "Uc电压偏差(V)",
    "pttl": "有功功率P(kW)", "qttl": "无功功率Q(kVar)", "sttl": "视在功率(kVA)",
    "costtl": "功率因数", "phA": "A相角(°)", "phB": "B相角(°)", "phC": "C相角(°)",
    "ph": "相角(°)", "freq_dev": "频率偏差(Hz)",
    "ubl": "电压三相不平衡度(%)", "ibl": "电流三相不平衡度(%)", "Atemp": "A线温度(℃)",
    "Btemp": "B线温度(℃)", "Ctemp": "C线温度(℃)", "Ntemp": "N线温度(℃)",
    "residual_current": "漏电流(mA)",
    "thuab": "Uab总谐波畸变率(%s)", "hr3uab": "Uab3次谐波畸变率(%s)",
    "hr5uab": "Uab5次谐波畸变率(%s)", "hr7uab": "Uab7次谐波畸变率(%s)",
    "hr9uab": "Uab9次谐波畸变率(%s)", "hr11uab": "Uab11次谐波畸变率(%s)",
    "hr13uab": "Uab13次谐波畸变率(%s)",
    "thucb": "Ucb总谐波畸变率(%s)", "hr3ucb": "Ucb3次谐波畸变率(%s)",
    "hr5ucb": "Ucb5次谐波畸变率(%s)", "hr7ucb": "Ucb7次谐波畸变率(%s)",
    "hr9ucb": "Ucb9次谐波畸变率(%s)", "hr11ucb": "Ucb11次谐波畸变率(%s)",
    "hr13ucb": "Ucb13次谐波畸变率(%s)",
    "thdua": "Ua总谐波畸变率(%s)", "hr3ua": "Ua3次谐波畸变率(%s)",
    "hr5ua": "Ua5次谐波畸变率(%s)", "hr7ua": "Ua7次谐波畸变率(%s)",
    "hr9ua": "Ua9次谐波畸变率(%s)", "hr11ua": "Ua11次谐波畸变率(%s)",
    "hr13ua": "Ua13次谐波畸变率(%s)",
    "thdub": "Ub总谐波畸变率(%s)", "hr3ub": "Ub3次谐波畸变率(%s)",
    "hr5ub": "Ub5次谐波畸变率(%s)", "hr7ub": "Ub7次谐波畸变率(%s)",
    "hr9ub": "Ub9次谐波畸变率(%s)", "hr11ub": "Ub11次谐波畸变率(%s)",
    "hr13ub": "Ub13次谐波畸变率(%s)",
    "thduc": "Uc总谐波畸变率(%s)", "hr3uc": "Uc3次谐波畸变率(%s)",
    "hr5uc": "Uc5次谐波畸变率(%s)", "hr7uc": "Uc7次谐波畸变率(%s)",
    "hr9uc": "Uc9次谐波畸变率(%s)", "hr11uc": "Uc11次谐波畸变率(%s)",
    "hr13uc": "Uc13次谐波畸变率(%s)",
    "thdia": "Ia总谐波畸变率(%s)", "hr3ia": "Ia3次谐波畸变率(%s)",
    "hr5ia": "Ia5次谐波畸变率(%s)", "hr7ia": "Ia7次谐波畸变率(%s)",
    "hr9ia": "Ia9次谐波畸变率(%s)", "hr11ia": "Ia11次谐波畸变率(%s)",
    "hr13ia": "Ia13次谐波畸变率(%s)",
    "thdib": "Ib总谐波畸变率(%s)", "hr3ib": "Ib3次谐波畸变率(%s)",
    "hr5ib": "Ib5次谐波畸变率(%s)", "hr7ib": "Ib7次谐波畸变率(%s)",
    "hr9ib": "ib9次谐波畸变率(%s)", "hr11ib": "Ib11次谐波畸变率(%s)",
    "hr13ib": "Ib13次谐波畸变率(%s)",
    "thdic": "Ic总谐波畸变率(%s)", "hr3ic": "Ic3次谐波畸变率(%s)",
    "hr5ic": "Ic5次谐波畸变率(%s)", "hr7ic": "Ic7次谐波畸变率(%s)",
    "hr9ic": "Ic9次谐波畸变率(%s)", "hr11ic": "Ic11次谐波畸变率(%s)",
    "hr13ic": "Ic13次谐波畸变率(%s)",
    "thdi": "电流谐波畸变率",
    "fdiea": "Ia总电流谐波有效值(A)", "fd3ia": "Ia3次电流谐波有效值(A)",
    "fd5ia": "Ia5次电流谐波有效值(A)", "fd7ia": "Ia7次电流谐波有效值(A)",
    "fd9ia": "Ia9次电流谐波有效值(A)", "fd11ia": "Ia11次电流谐波有效值(A)",
    "fd13ia": "Ia13次电流谐波有效值(A)",
    "fdieb": "Ib总电流谐波有效值(A)", "fd3ib": "Ib3次电流谐波有效值(A)",
    "fd5ib": "Ib5次电流谐波有效值(A)", "fd7ib": "Ib7次电流谐波有效值(A)",
    "fd9ib": "Ib9次电流谐波有效值(A)", "fd11ib": "Ib11次电流谐波有效值(A)",
    "fd13ib": "Ib13次电流谐波有效值(A)",
    "fdiec": "Ic总电流谐波有效值(A)", "fd3ic": "Ia3次电流谐波有效值(A)",
    "fd5ic": "ic5次电流谐波有效值(A)", "fd7ic": "Ic7次电流谐波有效值(A)",
    "fd9ic": "Ic9次电流谐波有效值(A)", "fd11ic": "Ic11次电流谐波有效值(A)",
    "fd13ic": "Ic13次电流谐波有效值(A)",
}

PHYSICAL_MORE = {
    "u": {2: ["uab", "ucb"], 3: ["ua", "ub", "uc"]},
    "i": {2: ["ia", "ic"], 3: ["ia", "ib", "ic"]},
    "u_dev": {2: ["uab_dev", "ucb_dev"], 3: ["ua_dev", "ub_dev", "uc_dev"]},
    "ph": {2: [], 3: ["phA", "phB", "phC"]},
    "thdu": {
        2: [
            "thduab", "hr3uab", "hr5uab", "hr7uab", "hr9uab", "hr11uab",
            "hr13uab", "thducb", "hr3ucb", "hr5ucb", "hr7ucb", "hr9ucb",
            "hr11ucb", "hr13ucb"
        ],
        3: [
            "thdua", "hr3ua", "hr5ua", "hr7ua", "hr9ua", "hr11ua", "hr13ua",
            "thdub", "hr3ub", "hr5ub", "hr7ub", "hr9ub", "hr11ub", "hr13ub",
            "thduc", "hr3uc", "hr5uc", "hr7uc", "hr9uc", "hr11uc", "hr13uc"
        ]
    },
    "thdi": {
        2: [
            "thdia", "hr3ia", "hr5ia", "hr7ia", "hr9ia", "hr11ia", "hr13ia",
            "thdic", "hr3ic", "hr5ic", "hr7ic", "hr9ic", "hr11ic", "hr13ic"
        ],
        3: [
            "thdia", "hr3ia", "hr5ia", "hr7ia", "hr9ia", "hr11ia", "hr13ia",
            "thdic", "hr3ic", "hr5ic", "hr7ic", "hr9ic", "hr11ic", "hr13ic",
            "thdib", "hr3ib", "hr5ib", "hr7ib", "hr9ib", "hr11ib", "hr13ib",
        ]
    },
    "fdie": {
        2: [
            "fdia", "fdic",
            "thdia", "hr3ia", "hr5ia", "hr7ia", "hr9ia", "hr11ia", "hr13ia",
            "thdic", "hr3ic", "hr5ic", "hr7ic", "hr9ic", "hr11ic", "hr13ic"
        ],
        3: [
            "fdia", "fdib", "fdic",
            "thdia", "hr3ia", "hr5ia", "hr7ia", "hr9ia", "hr11ia", "hr13ia",
            "thdic", "hr3ic", "hr5ic", "hr7ic", "hr9ic", "hr11ic", "hr13ic",
            "thdib", "hr3ib", "hr5ib", "hr7ib", "hr9ib", "hr11ib", "hr13ib",
        ]},
}

ALLOWED_EXTENSIONS = {'txt', 'pdf', 'png', 'jpg', 'jpeg', 'gif', 'PNG',
                      'xlsx', 'doc', 'xls', 'docx', 'ppt', 'pptx', 'rtf'}