from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Str, Int, List, Dict, Float


@dataclass
class EquOptReq(Model):
    product: int = Opt(Int('项目id').eg(1))
    cid: int = Opt(Int('客户id').eg(45))
    pid: int = Opt(Int('监测点id 0表示全部').eg(45))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)
    sid: str = Opt(Str('硬件编号').eg("A1904000583"))


@dataclass
class Alarm(Model):
    product: int = Opt(Int('项目id').eg(1))
    productname: str = Opt(Str('项目名').eg("安电U+"))
    cid: int = Opt(Int('客户id').eg(45))
    shortname: str = Opt(Str('客户名').eg("富通九曜公馆主体工程"))
    pid: int = Opt(Int('监测点id').eg(45))
    name: str = Opt(Str('监测点名').eg("负4层照明"))
    mtid: int = Opt(Int('mtid').eg(45))
    sid: str = Opt(Str('硬件编号').eg("A1904000583"))


@dataclass
class EquOptResp(Model):
    total: int = Int('总量').eg(1)
    rows: list = List('信息').items(Alarm)
    is_mod: int = Int('是否显示修改按钮 1显示 0不显示').eg(0)


@dataclass
class EquOptDetailReq(Model):
    pid: int = Int('监测点id').eg(1)


@dataclass
class EdReq(Model):
    sid: str = Str('硬件编号').eg("A1904000635")
    mtid: int = Int('mtid').eg(45)


@dataclass
class EdmReq(Model):
    sid: str = Str('硬件编号').eg("A1904000635")
    mtid: int = Int('mtid').eg(45)


@dataclass
class EdResp(Model):
    software_version: str = Str('代码版本').eg("V2.2.1-R")
    device_status: str = Str('当前状态').eg("在线")
    scope_status: str = Str('录波当前状态').eg("开启")
    upload_freq: float = Float('上传频率').eg("1.0")
    harm_count: int = Int('谐波次数').eg(17)
    iccid: str = Str('iccid').eg("89860479252070520071")
    sim_operator: str = Str('SIM运营商').eg("中国移动")


@dataclass
class EdmResp(Model):
    ct: int = Int('ct').eg(20)
    pt: int = Int('pt').eg(1)
    rated_voltage: int = Int('额定电压').eg(220)
    rated_current: int = Int('额定电流').eg(20)
    alarm: list = List('报警').eg([{
            "type": "参数类型",
            "threshold": "阈值",
            "duration": "时长",
            "enable": "开关状态",
        }])


@dataclass
class EcnReq(Model):
    mtid: str = Str('mtid').eg("1")
    pid: int = Int('监测点id').eg(21)
    new_name: str = Str("新监测点名称").eg("1#电房10kV进线1")


@dataclass
class ErReq(Model):
    cid: int = Int('cid').eg(32)
    sid: str = Str('硬件编号').eg("A1904000109")
    new_sid: str = Str('硬件编号').eg("A1904000109")


@dataclass
class EdmlReq(Model):
    cid: int = Int('cid').eg(32)
    sid: str = Str('硬件编号').eg("A1904000109")
