from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, List, Str


@dataclass
class PageDataResp(Model):
    electric_sum: str = Str("累计用电量").eg("210亿")
    risk_less: str = Str("减少风险量").eg("5000万")
    c_emission_less: str = Str("减少碳排放量").eg("1260万")
    user_safe: str = Str("减少碳排放量").eg("1200万")


@dataclass
class ApplyTrialReq(Model):
    name: str = Str("姓名").eg("张三")
    email: str = Str("邮箱").eg("xxx@163.com")
    company: str = Str("公司").eg("清科优能")
    phone: str = Str("姓名").eg("13345678945")
    product: int = Int("产品").eg(1)
