from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, Str, List, Opt, Dict


@dataclass
class PcStatiReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(-1)
    date_type: str = Str("时间类型->day/month/year/range").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")


@dataclass
class SlotValue(Model):
    slots: list = List("slots").eg(["00:00", "00:15", "00:30"])
    value: list = List("时间段对应的值").eg([0.1, 0.2, 0.3])


@dataclass
class PcStatiResp(Model):
    kwh: SlotValue = Opt(SlotValue)
    charge: SlotValue = Opt(SlotValue)
    today_p: SlotValue = Opt(SlotValue)
    yesterday_p: SlotValue = Opt(SlotValue)
    this_aver_price: SlotValue = Opt(SlotValue)
    last_aver_price: SlotValue = Opt(SlotValue)
    kwh_15min: SlotValue = Opt(SlotValue)
    charge_15min: SlotValue = Opt(SlotValue)
    co2: SlotValue = Opt(SlotValue)  # 智电U加co2


@dataclass
class MaxpReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(-1)
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")


@dataclass
class MaxpResp(Model):
    maxp: int = Int("最大需量").eg(380)
    date_time: str = Str("时间点").eg("2020-05-07 18:30")


@dataclass
class PcDownloadReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(-1)
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")


@dataclass
class PcDownloadResp(Model):
    kwh: SlotValue = Opt(SlotValue)
    charge: SlotValue = Opt(SlotValue)


@dataclass
class PcmResp(Model):
    max_p: dict = Dict("最大需量").eg({"value": 100.1, "time": "11:00-12:00"})
    max_kwh: dict = Dict("电量最多").eg({"value": 100.1, "time": "11:00-12:00"})
    min_kwh: dict = Dict("电量最少").eg({"value": 10.1, "time": "11:00-12:00"})
    max_charge: dict = Dict("电费最多").eg({"value": 100.1, "time": "11:00-12:00"})
    min_charge: dict = Dict("电费最少").eg({"value": 100.1, "time": "11:00-12:00"})
