from pot_libs.mysql_util.mysql_util import MysqlUtil


async def inline_zdu_by_cid(cid):
    """inline_zdu"""
    sql = "SELECT * from inline iz inner join monitor m2 " \
          "on iz.mtid = m2.mtid where iz.cid = %s " \
          "order by iz.sort_num"
    async with MysqlUtil() as conn:
        inline_zdu_list = await conn.fetchall(sql, args=(cid,))
    return inline_zdu_list


async def feeder_by_cid(cid):
    """馈线"""
    sql = "SELECT * from feeder f inner join monitor m2 " \
          "on f.mtid = m2.mtid where f.cid = %s " \
          "order by f.sort_num"
    async with MysqlUtil() as conn:
        feeder_list = await conn.fetchall(sql, args=(cid,))
    return feeder_list


async def transformer_by_cid(cid):
    """变压器"""
    sql = "SELECT * from transformer t inner join monitor m2 " \
          "on t.mtid = m2.mtid where t.cid = %s " \
          "order by t.sort_num"
    async with MysqlUtil() as conn:
        transformer_list = await conn.fetchall(sql, args=(cid,))
    return transformer_list


async def power_dist_by_cid(cid):
    """配电"""
    sql = "SELECT * from power_dist pd inner join monitor m2 " \
          "on pd.mtid = m2.mtid where pd.cid = %s " \
          "order by pd.sort_num"
    async with MysqlUtil() as conn:
        power_dist_list = await conn.fetchall(sql, args=(cid,))
    return power_dist_list


async def device_level_by_cid(cid):
    """设备级"""
    sql = "SELECT * from device_level dl inner join monitor m2 " \
          "on dl.mtid = m2.mtid where dl.cid = %s " \
          "order by dl.sort_num"
    async with MysqlUtil() as conn:
        device_list = await conn.fetchall(sql, args=(cid,))
    return device_list
