from pot_libs.sanic_api import summary
from unify_api.modules.carbon_neutral.components.carbon_reduce_cps import \
    CiResp, TaResp, CeiResp
from unify_api.modules.carbon_neutral.service.carbon_reduce_service import \
    carbon_summary_service, trend_analysis_service, \
    carbon_emission_index_service
from unify_api.modules.common.components.common_cps import CidStartEndReq, \
    CidReq
from unify_api.utils.time_format import last_month_start_end


@summary("碳中和-统计概况信息")
async def post_carbon_summary(req, body: CidStartEndReq) -> CiResp:
    cid = body.cid
    start = body.start
    end = body.end
    return await carbon_summary_service(cid, start, end)


@summary("碳中和-趋势分析")
async def post_trend_analysis(req, body: CidStartEndReq) -> TaResp:
    cid = body.cid
    start = body.start
    end = body.end
    return await trend_analysis_service(cid, start, end)


@summary("首页-碳排指数等信息")
async def post_carbon_emission_index(req, body: CidReq) -> CeiResp:
    cid = body.cid
    # 上个月起止时间
    start, end = last_month_start_end()
    return await carbon_emission_index_service(cid, start, end)
