# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/9
from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Float, Opt
from unify_api.utils.response_code import DbErr


@dataclass
class AlarmSetting(Model):
    id: int = Int('数据库表ID')
    type: str = Str('设置类型：【electric，adio】').eg('electric')
    name: str = Str(
        '电气量直接取name, adio量取{item}{type}'
    ).eg('A相温度告警')
    level: int = Int('等级').eg(2)
    threshold: float = Float('阈值').eg(80)
    duration: int = Opt(Int('持续时间').eg(60))
    enable: int = Int('是否启用：0|1').eg(1)


@dataclass
class AlarmSettingUpdate(Model):
    id: int = Int('数据库表ID')
    threshold: float = Float('阈值').eg(80)
    duration: int = Opt(Int('持续时间').eg(60))
    enable: int = Int('是否启用：0|1').eg(1)
    cid: Cid = Cid


@dataclass
class AlarmSettingResponse(Model):
    total: int = Int('总量')
    rows: list = List("所有设置").items(AlarmSetting)


@dataclass
class PointAlarmSettingRequest(Model):
    point_id: int = Int('point_id')
    location_ids: list = List("location_ids").items(Int('location_id'))
    enable: int = Opt(Int('不传【ALL】：0【禁用】|1【启用】').eg(1))


@dataclass
class PointAlarmSettingResponse(Model, DbErr):
    residual_current_op: int = Opt(Int("1-漏电流可操作, 0-漏电流不可操作"))
    point_alarm_settings: list = List("point_alarm_setting").items(
        AlarmSetting)
    location_alarm_settings: list = List("location_alarm_setting").items(
        AlarmSetting)


point_alarm_setting_example = {
    "范例1": {
        "point_id": 128,
        "location_ids": [136, 137, 138, 139, 140],
        "enable": 1
    }
}
