from pot_libs.sanic_api.http_status import db_error, user_error, unauthorized, \
    success, param_error, internal_server_error


class DbErr(object):
    @classmethod
    @db_error
    def db_error(cls):
        """数据库操作失败"""
        return '数据库操作失败'


class UserErr(object):
    @classmethod
    @user_error
    def user_error(cls):
        """用户信息错误"""
        return '用户信息错误'


class JwtErr(object):
    @classmethod
    @unauthorized
    def missing_jwt(cls):
        """缺失token头信息"""
        return '缺失参数:header jwt信息'


class Success(object):
    @classmethod
    @success
    def success(cls):
        """操作成功"""
        return '操作成功'


class ParamErr(object):
    @classmethod
    @param_error
    def param_error(cls):
        """传参错误"""
        return "参数错误"


class ServerErr(object):
    @classmethod
    @internal_server_error
    def server_error(cls):
        """服务器内部错误"""
        return "服务器内部错误"


class RET(object):
    """自定义状态码"""
    # 联动控制
    ok = 200
    op_fail = 5100  # 操作失败
    send_sms_fail = 5101  # 发送短信失败
    send_sms_quick = 5102  # 发送短信太频繁
    send_sms_quick2 = 51002  # 发送短信太频繁, 阿里云限制 1/1min  5/1h  10/day
    password_error = 5103  # 两次密码不一致
    verify_error = 5104  # 验证码不一致
    params_loss = 5105  # 缺少必传参数
    wechat_error = 5106  # 微信绑定失败
    wechat_repeat = 5107  # 该微信号已经被绑定
    phone_repeat = 5108  # 该手机号码已经被绑定
    code_is_low = 5109  # code失效
    phone_not_register = 5110  # 该手机号未注册
    already_submit = 5111  # 数据已提交
    permissions_no_enough = 5112  # 权限不足
    close_fail = 50003  # 闭合失败: 连接emq超时/硬件500, 且为断开->闭合
    emq_time_out = 50004  # 连接emq超时, 其他
    hardware_time_out = 50005  # 硬件返回500
    not_data = 50006  # 没有找到数据

