import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "month": "2020-10",
        "cids": [66, 73, 74],
        "product": 0
    },
])
@pytest.mark.asyncio
async def test_elec_count_info(data):
    """安电u管理版本-综合排名"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/electric/proxy-ranking"
            f"/elec-count-info",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["safety"], resp_str["data"]["health"],
                resp_str["data"]["kwh"]])
