import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_power_statis_proxy(data):
    """
    代理版电量电费统计曲线
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statis-proxy"
            f"/power-statis-proxy",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["kwh"]["slots"],
                resp_str["data"]["kwh"]["value"]])


@pytest.mark.parametrize('data', [
    {
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_power_statis_sdu(data):
    """
    识电u首页电量电费统计曲线
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statis-proxy"
            f"/power-statis-sdu",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["kwh"]["slots"],
                resp_str["data"]["kwh"]["value"]])


@pytest.mark.parametrize('data', [
    {
        "cid_list": [32, 36],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
    {
        "cid_list": [32, 36],
        "date_type": "month",
        "start": "2020-07-01 00:00:00",
        "end": "2020-07-30 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_power_statist_opt(data):
    """
    电量电费统计曲线-优化版-管理版
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statis-proxy"
            f"/power-statist-opt",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["kwh"]["slots"],
                resp_str["data"]["kwh"]["value"]])
