import json
import pytest
from unify_api.tests.constants_t import post_request


class TestSelectCompany(object):
    url = "/unify-api/common/select-company/select-company"

    @pytest.mark.parametrize('data', [{
        # "province": "全国",
        # "input_str": "微众",
        # "cid_list": [],
        # "product": 3,  # 3,4,5需要ctx 所以关闭了
        # "proxy_id": 1}, {
        "province": "全国",
        "input_str": "微众",
        "cid_list": [66, 118],
        "product": 0}, {
        "province": "广东",
        "input_str": "微众",
        "cid_list": [66, 118],
        "product": 0}
    ])
    @pytest.mark.asyncio
    async def test_select_company(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["select_company"][0]["cid"] == 66

    @pytest.mark.parametrize('data', [{
        "province": "江西",
        "input_str": "微众",
        "cid_list": [66, 118],
        "product": 0}, {
        "province": "广东",
        "input_str": "招商",
        "cid_list": [666, 1118],
        "product": 1}])
    @pytest.mark.asyncio
    async def test_select_company_no_data(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["select_company"] == []

    @pytest.mark.parametrize('data', [{
        "province": "",
        "input_str": "",
        "cid_list": [],
        "product": 0}])
    @pytest.mark.asyncio
    async def test_select_company_500(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 500


# @pytest.mark.parametrize('data', [
#     {
#         "cid": 118,
#     }, {
#         "cid": 66,
#     }
# ])
# @pytest.mark.asyncio
# async def test_company_model(data):
#     """
#     智电U首页工厂模型
#     """
#     resp_str, status = await AioHttpUtils().post(
#         url=f"{HTTP_PREFIX}/unify-api/common/select-company/company-model",
#         data=data,
#         timeout=10,
#         headers={"Authorization": f"Bearer {TOKEN}"}
#     )
#     assert status == 200
#     resp_str = json.loads(resp_str)
#     assert resp_str["data"]["cid"] == data["cid"]
