import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
       "location_ids": [765, 766, 767, 768, 769],
       "point_id": 327
    },
])
@pytest.mark.asyncio
async def test_point_alarm_setting(data):
    """
    报警信息列表
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/alarm-manager/alarm-setting"
            f"/point-alarm-setting",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["point_alarm_settings"]


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "storeys": [1, 2, 3],
        "importance": [1, 2, 3],
        "page_size": 20,
        "page_num": 1,
        "start": "2020-05-01 00:00:00",
        "end": "2021-03-10 23:59:59",
        "product": 4
    },
])
@pytest.mark.asyncio
async def test_new_list_alarm(data):
    """
    报警记录-列表分页
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/alarm-manager/list-alarm/new-list-alarm",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total"] == len(resp_str["data"]["rows"])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_list": [439, 440],
        "importance": [1, 2, 3],
        "page_size": 20,
        "page_num": 1,
        "start": "2020-05-01 00:00:00",
        "end": "2021-03-10 23:59:59",
        "event_type": [
            "overTempRange1min",
            "overTHDU"
        ],
        "product": 6
    },
])
@pytest.mark.asyncio
async def test_list_alarm_zdu(data):
    """
    报警记录-列表分页-智电u
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/alarm-manager/list-alarm/list-alarm-zdu",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total"] == len(resp_str["data"]["rows"])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_list": [439, 440],
        "start": "2020-05-01 00:00:00",
        "end": "2021-03-10 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_wx_list_alarm_zdu(data):
    """
    小程序消息列表-智电u
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/alarm-manager/list-alarm/"
            f"wx-list-alarm-zdu",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["total"] == len(resp_str["data"]["rows"])
