from pot_libs.sanic_api import summary
from unify_api.modules.zhiwei_u.components.warning_operations_cps import \
    SelectUserResp, Success, SuccessResp, FileSuccess
from unify_api.modules.zhiwei_u.components.order_operations_cps import \
    ReceiveOrderReq, ReceiveOrderResp, FlowOrderReq, WorkOrderReq, \
    AddOrderReq, SidToOrderReq, SidToOrderResp, PidToSidReq, \
    DeleteOrderFileReq
from unify_api.modules.zhiwei_u.service.order_operations_service import \
    receive_order_service, flow_order_user_service, flow_order_service, \
    work_order_service, close_order_service, add_order_service, \
    sid_to_order_service, pid_to_sid_service, search_all_user_service, \
    order_detail_service, order_detail_flow_service, w_origin_service, \
    delete_order_file_service, download_file_service, upload_file_service

# 运维工单


@summary('来源')
async def get_w_origin(req) -> SelectUserResp:
    return await w_origin_service()


@summary('获取所有用户')
async def get_search_all_user(req) -> SelectUserResp:
    return await search_all_user_service()


@summary('接单')
async def post_receive_order(req, body: ReceiveOrderReq) -> ReceiveOrderResp:
    id = body.id
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    return await receive_order_service(id, user_id)


@summary('转单  获取名单')
async def get_flow_order_user(req) -> SelectUserResp:
    return await flow_order_user_service()


@summary('转单')
async def post_flow_order(req, body: FlowOrderReq) -> FileSuccess:
    try:
        myself_id = req.ctx.user_id
    except:
        myself_id = req.json.get("myself_id")
    id = body.id
    user_id = body.user_id
    explain = body.explain
    doc_ids = body.doc_ids
    return await flow_order_service(myself_id, id, user_id, explain, doc_ids)


@summary('处理  工单')
async def post_work_order(req, body: WorkOrderReq) -> FileSuccess:
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    id = body.id
    explain = body.explain
    doc_ids = body.doc_ids
    return await work_order_service(id, user_id, explain, doc_ids)


@summary('关闭 工单')
async def post_close_order(req, body: WorkOrderReq) -> FileSuccess:
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    id = body.id
    explain = body.explain
    doc_ids = body.doc_ids
    return await close_order_service(id, user_id, explain, doc_ids)


@summary('录入工单  传入硬件编号sid 返回 cid、pid')
async def post_sid_to_order(req, body: SidToOrderReq) \
        -> SidToOrderResp:
    sid = body.sid
    return await sid_to_order_service(sid)


@summary('录入工单  根据cid、监测点pid返回硬件编号')
async def post_pid_to_sid(req, body: PidToSidReq) -> SidToOrderResp:
    pid = body.pid
    return await pid_to_sid_service(pid)


@summary('录入工单 或修改工单 传id')
async def post_add_order(req, body: AddOrderReq) -> Success:
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    id = body.id
    prod_id = body.prod_id
    cid = body.cid
    point_id = body.point_id
    check_dt = body.check_dt
    sid = body.sid
    doc_ids = body.doc_ids
    return await add_order_service(req.json, id, user_id, prod_id, cid,
                                   check_dt, sid, point_id, doc_ids)


@summary('工单详情')
async def post_order_detail(req, body: ReceiveOrderResp) -> SidToOrderResp:
    id = body.id
    return await order_detail_service(id)


@summary('工单详情-流程')
async def post_order_detail_flow(req, body: ReceiveOrderResp) -> \
        SidToOrderResp:
    id = body.id
    return await order_detail_flow_service(id)


@summary('附件上传')
async def post_upload_file(req):
    cid = req.form.get("cid")
    return await upload_file_service(req, cid)


@summary('运维工单-附件删除')
async def post_delte_order_file(req, body: DeleteOrderFileReq) -> \
        SuccessResp:
    id = body.id
    return await delete_order_file_service(id)


@summary('运维工单-附件下载')
async def get_download_file(req):
    id = req.args.get("id")
    return await download_file_service(id)
