from unify_api.modules.zhiwei_u.procedures.common import get_order_num
from unify_api.modules.zhiwei_u import config
from pot_libs.common.components.responses import Success
from unify_api.modules.zhiwei_u.dao.warning_operations_dao import *
from unify_api.modules.zhiwei_u.dao.order_operations_dao import \
    order_num_is_having, search_all_handle_user_dao
from unify_api.modules.zhiwei_u.components.warning_operations_cps import \
    SelectUserResp, ProductResp
from pot_libs.aiokafka_util.kafka_util import KafkaUtils


async def get_product_service(goods):
    """返回平台  工单类型  报警类型"""
    data = []
    for key, value in goods.items():
        product = {
            "id": key,
            "name": value
        }
        data.append(product)
    return ProductResp(data)


async def select_user_service(prod_id):
    """根据平台选择客户 """
    user_list = await select_user_dao(prod_id)
    return SelectUserResp(data=user_list)


async def select_point_service(cid):
    """根据平台 客户选择监测点 """
    point_list = await select_point_dao(cid)
    return SelectUserResp(data=point_list)


async def warning_state_ignore_service(ids, remark):
    """运维报警状态改变为已忽略"""
    if not ids:
        return Success(success=0, message="操作失败")
    try:
        ids = [int(i) for i in ids]
    except:
        log.info(f"warning_state_ignore_service ids:{ids}")
        return Success(success=0, message="操作失败")
    await warning_state_ignore_dao(ids, config.WARNING_IGNORE, remark)
    return Success(success=1, message="操作成功")


async def warning_state_focus_service(ids):
    """运维报警 已忽略撤销"""
    if not ids:
        return Success(success=0, message="操作失败")
    try:
        ids = [int(i) for i in ids]
    except:
        log.info(f"warning_state_focus_service ids:{ids}")
        return Success(success=0, message="操作失败")
    await warning_state_focus_dao(ids, config.WARNING_FOCUS)
    return Success(success=1, message="操作成功")


async def warning_to_order_service(ids, userid, w_origin):
    """报警信息转为工单"""
    if not ids:
        return Success(success=0, message="操作失败")
    try:
        ids = [int(i) for i in ids]
    except:
        log.info(f"warning_to_order_service ids:{ids}")
        return Success(success=0, message="操作失败")
    # 修改报警state
    await warning_state_focus_dao(ids, config.WARNING_ORDER)
    # 查询该条记录数据
    for id in ids:
        data = await get_warn_by_id(id)
        if data:
            while 1:
                # 生成工单号
                order_num = get_order_num(w_origin)
                # 判断工单号是否存在
                is_having = await order_num_is_having(order_num)
                if not is_having:
                    break
            # 插入工单表
            await insert_order_data(data, w_origin, order_num, userid)
            handle_user_list = await search_all_handle_user_dao()
            dic_data = {
                "order_num": order_num,
                "project": config.PRODUCT[data["prod_id"]],
                "point": data["monitor_name"],
                "sid": data["sid"],
                "order_content": data["warn_info"],
                "notice_content": "已生成工单，请及时接单处理",
                "user_list": [handle_user["user_id"]
                              for handle_user in handle_user_list]
            }
            await KafkaUtils.send_msg(
                topic="power_iot.push.wechat_operation_order",
                dic_data=dic_data)
    return Success(success=1, message="操作成功")
