from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Str, Int, List, Float, Dict


@dataclass
class SidToParamsReq(Model):
    sid: str = Opt(Str("监测点pid 与sid 必传一个").eg("A1904000088"))
    pid: int = Opt(Int("监测点pid 与sid 必传一个").eg(21))


@dataclass
class MtidToInfoReq(Model):
    mtid: int = Opt(Int("mtid 与sid 必传一个").eg(12))


@dataclass
class MtidToInfoResp(Model):
    sid: str = Str("sid").eg("A1904000088")
    cid: int = Int("cid").eg(12)
    prod_id: int = Int("prod_id").eg(12)
    product: str = Str("product").eg(12)
    shortname: str = Str("compy_name").eg("123")
    pid: int = Int("pid").eg(12)
    name: str = Str("point").eg("123")


@dataclass
class DataOperationSearchReq(Model):
    mtid: int = Opt(Int("mtid").eg(10))
    point: int = Opt(Int("监测点id 与mtid 必传一个").eg(21))
    params: list = List("参数").eg(["u_dev", "temperature",
                                  "residual_current", "fdie"])
    start: str = Str("开始时间").eg("2021-07-01 00:00:00")
    end: str = Str("结束时间").eg("2021-07-01 23:59:59")


@dataclass
class U(Model):
    """电压"""
    ua: list = Opt(List('ua').items(Float()))
    ub: list = Opt(List('ub').items(Float()))
    uc: list = Opt(List('uc').items(Float()))
    uab: list = Opt(List('uab').items(Float()))
    ucb: list = Opt(List('ucb').items(Float()))


@dataclass
class I(Model):
    """电流"""
    ia: list = List('ia').items(Float())
    ib: list = Opt(List('ib').items(Float()))
    ic: list = List('ic').items(Float())


@dataclass
class PH(Model):
    """相角"""
    phA: list = Opt(List('phA').items(Float()))
    phB: list = Opt(List('phB').items(Float()))
    phC: list = Opt(List('phC').items(Float()))


@dataclass
class UDEV(Model):
    """电压偏差"""
    ua_dev: float = Opt(Float("电压偏差"))
    ub_dev: float = Opt(Float("电压偏差"))
    uc_dev: float = Opt(Float("电压偏差"))
    uab_dev: float = Opt(Float("电压偏差"))
    ucb_dev: float = Opt(Float("电压偏差"))


@dataclass
class TEMP(Model):
    """温度"""
    Atemp: float = Opt(Float("A相温度"))
    Btemp: float = Opt(Float("B相温度"))
    Ctemp: float = Opt(Float("C相温度"))
    Ntemp: float = Opt(Float("N相温度"))


@dataclass
class VoltageHarmonicRate(Model):
    """电压谐波畸变率"""
    thdua: float = Opt(Float("ua总谐波畸变率"))
    thdub: float = Opt(Float("ub总谐波畸变率"))
    thduc: float = Opt(Float("uc总谐波畸变率"))

    thduab: float = Opt(Float("uab总谐波畸变率"))
    thducb: float = Opt(Float("uab总谐波畸变率"))

    hr3ua: float = Opt(Float("hr3ua谐波畸变率"))
    hr3ub: float = Opt(Float("hr3ub谐波畸变率"))
    hr3uc: float = Opt(Float("hr3uc谐波畸变率"))
    hr3uab: float = Opt(Float("hr3uab谐波畸变率"))
    hr3ucb: float = Opt(Float("hr3ucb谐波畸变率"))

    hr5ua: float = Opt(Float("hr5ua谐波畸变率"))
    hr5ub: float = Opt(Float("hr5ub谐波畸变率"))
    hr5uc: float = Opt(Float("hr5uc谐波畸变率"))
    hr5uab: float = Opt(Float("hr5uab谐波畸变率"))
    hr5ucb: float = Opt(Float("hr5ucb谐波畸变率"))

    hr7ua: float = Opt(Float("hr7ua谐波畸变率"))
    hr7ub: float = Opt(Float("hr7ub谐波畸变率"))
    hr7uc: float = Opt(Float("hr7uc谐波畸变率"))
    hr7uab: float = Opt(Float("hr7uab谐波畸变率"))
    hr7ucb: float = Opt(Float("hr7ucb谐波畸变率"))

    hr9ua: float = Opt(Float("hr9ua谐波畸变率"))
    hr9ub: float = Opt(Float("hr9ub谐波畸变率"))
    hr9uc: float = Opt(Float("hr9uc谐波畸变率"))
    hr9uab: float = Opt(Float("hr9uab谐波畸变率"))
    hr9ucb: float = Opt(Float("hr9ucb谐波畸变率"))

    hr11ua: float = Opt(Float("hr11ua谐波畸变率"))
    hr11ub: float = Opt(Float("hr11ub谐波畸变率"))
    hr11uc: float = Opt(Float("hr11uc谐波畸变率"))
    hr11uab: float = Opt(Float("hr11uab谐波畸变率"))
    hr11ucb: float = Opt(Float("hr11ucb谐波畸变率"))

    hr13ua: float = Opt(Float("hr13ua谐波畸变率"))
    hr13ub: float = Opt(Float("hr13ub谐波畸变率"))
    hr13uc: float = Opt(Float("hr13uc谐波畸变率"))
    hr13uab: float = Opt(Float("hr13uab谐波畸变率"))
    hr13ucb: float = Opt(Float("hr13ucb谐波畸变率"))


@dataclass
class CurrentHarmonicRate(Model):
    """电流谐波畸变率"""
    thdia: float = Opt(Float("ia总谐波畸变率"))
    thdib: float = Opt(Float("ib总谐波畸变率"))
    thdic: float = Opt(Float("ic总谐波畸变率"))

    hr3ia: float = Opt(Float("hr3ia谐波畸变率"))
    hr3ib: float = Opt(Float("hr3ib谐波畸变率"))
    hr3ic: float = Opt(Float("hr3ic谐波畸变率"))

    hr5ia: float = Opt(Float("hr5ia谐波畸变率"))
    hr5ib: float = Opt(Float("hr5ib谐波畸变率"))
    hr5ic: float = Opt(Float("hr5ic谐波畸变率"))

    hr7ia: float = Opt(Float("hr7ia谐波畸变率"))
    hr7ib: float = Opt(Float("hr7ib谐波畸变率"))
    hr7ic: float = Opt(Float("hr7ic谐波畸变率"))

    hr9ia: float = Opt(Float("hr9ia谐波畸变率"))
    hr9ib: float = Opt(Float("hr9ib谐波畸变率"))
    hr9ic: float = Opt(Float("hr9ic谐波畸变率"))

    hr11ia: float = Opt(Float("hr11ia谐波畸变率"))
    hr11ib: float = Opt(Float("hr11ib谐波畸变率"))
    hr11ic: float = Opt(Float("hr11ic谐波畸变率"))

    hr13ia: float = Opt(Float("hr13ia谐波畸变率"))
    hr13ib: float = Opt(Float("hr13ib谐波畸变率"))
    hr13ic: float = Opt(Float("hr13ic谐波畸变率"))


@dataclass
class CurrentHarmonic(Model):
    """电流谐波分量  电流谐波有效值"""
    fdia: list = Opt(List('a相基波电流').items(Float()))
    fdib: list = Opt(List('b相基波电流').items(Float()))
    fdic: list = Opt(List('c相基波电流').items(Float()))

    thdia: list = Opt(List('a相电流总谐波畸变率').items(Float()))
    thdib: list = Opt(List('b相电流总谐波畸变率').items(Float()))
    thdic: list = Opt(List('c相电流总谐波畸变率').items(Float()))

    hr3ia: list = Opt(List('a相电流3次谐波畸变率').items(Float()))
    hr3ib: list = Opt(List('b相电流3次谐波畸变率').items(Float()))
    hr3ic: list = Opt(List('c相电流3次谐波畸变率').items(Float()))

    hr5ia: list = Opt(List('a相电流5次谐波畸变率').items(Float()))
    hr5ib: list = Opt(List('b相电流5次谐波畸变率').items(Float()))
    hr5ic: list = Opt(List('c相电流5次谐波畸变率').items(Float()))

    hr7ia: list = Opt(List('a相电流7次谐波畸变率').items(Float()))
    hr7ib: list = Opt(List('b相电流7次谐波畸变率').items(Float()))
    hr7ic: list = Opt(List('c相电流7次谐波畸变率').items(Float()))

    hr9ia: list = Opt(List('a相电流9次谐波畸变率').items(Float()))
    hr9ib: list = Opt(List('b相电流9次谐波畸变率').items(Float()))
    hr9ic: list = Opt(List('c相电流9次谐波畸变率').items(Float()))

    hr11ia: list = Opt(List('a相电流11次谐波畸变率').items(Float()))
    hr11ib: list = Opt(List('b相电流11次谐波畸变率').items(Float()))
    hr11ic: list = Opt(List('c相电流11次谐波畸变率').items(Float()))

    hr13ia: list = Opt(List('a相电流13次谐波畸变率').items(Float()))
    hr13ib: list = Opt(List('b相电流13次谐波畸变率').items(Float()))
    hr13ic: list = Opt(List('c相电流13次谐波畸变率').items(Float()))


@dataclass
class RESI(Model):
    """温度"""
    value_slots: list = Opt(List('漏电流').items(Float()))
    threhold: int = Opt(Int("阈值").eg("2"))


@dataclass
class DataOperationSearchResp(Model):
    ctnum: int = Int("2/3表法").eg("2")
    sdu_i: str = Opt(Str('识电U具体的电流项: ia/ib/ic')),
    sdu_u: str = Opt(Str('识电U具体的电压项: ua/ub/uc/uab/ucb')),
    u: U = Opt(U)
    i: I = Opt(I)
    freq: list = Opt(List('频率').items(Float()))
    pttl: list = Opt(List('有功功率').items(Float()))
    qttl: list = Opt(List('无功功率').items(Float()))
    sttl: list = Opt(List('视在功率').items(Float()))
    costtl: list = Opt(List('功率因数').items(Float()))
    freq_dev: list = Opt(List('频率偏差实时数值').items(Float()))
    ibl: list = Opt(List('电压三相不平衡度').items(Float()))
    ubl: list = Opt(List('电流三相不平衡度').items(Float()))
    ph: PH = Opt(PH)
    u_dev: UDEV = Opt(UDEV)
    voltage_harmonic: VoltageHarmonicRate = Opt(VoltageHarmonicRate)
    current_harmonic_rate: CurrentHarmonicRate = Opt(CurrentHarmonicRate)
    current_harmonic: CurrentHarmonic = Opt(CurrentHarmonic)
    time_slots: list = List('时间轴').items(Str('时间'))
    temperature: TEMP = Opt(TEMP)
    residual_current: RESI = Opt(RESI)


@dataclass
class ParamsResp(Model):
    data: list = List("cid").eg([
        {"cid": 32, "shortname": "大地水泥"},
        {"cid": 34, "shortname": "广东演示工厂1"},
    ])
