from pot_libs.sanic_api import summary
from unify_api.modules.tsp_water.components.drop_dust_cps import DdReq, DdResp, \
    DdwReq, DdwResp, DeReq, IrmResp, IosResp, ItiResp, WsStatiReq, WsStatiResp
from unify_api.modules.tsp_water.service.drop_dust_service import \
    post_drop_dust_service, post_drop_dust_wave_service, \
    drop_water_wave_service, index_run_monit_service, index_op_stat_service, \
    index_today_info_service, index_water_service, index_electric_service


@summary("降尘措施-卡片信息")
async def post_drop_dust(req, body: DdReq) -> DdResp:
    storeys = body.storeys
    return_list = []
    return DdResp(res_data=return_list)
    # return await post_drop_dust_service(storeys) todo:tsp 临时简单处理


@summary("降尘措施-雾炮-运行曲线")
async def post_drop_dust_wave(req, body: DdwReq) -> DdwResp:
    point_id = body.point_id
    start = body.start
    end = body.end
    # return await post_drop_dust_wave_service(point_id, start, end)
    return DdwResp(slots=[], value=[])


@summary("降尘措施-喷淋-运行曲线")
async def post_drop_water_wave(req, body: DdwReq) -> DdwResp:
    point_id = body.point_id  # 对应的tsp_id
    start = body.start
    end = body.end
    # return await drop_water_wave_service(point_id, start, end)
    return DdwResp(slots=[], value=[])


@summary("首页-运行监测-统计")
async def post_index_run_monit(req, body: DeReq) -> IrmResp:
    cid = body.cid
    # return await index_run_monit_service(cid)
    return IrmResp(water={}, fog_gun={})


@summary("首页-运行统计-扬尘")
async def post_index_op_stat(req, body: DeReq) -> IosResp:
    cid = body.cid
    # return await index_op_stat_service(cid)
    return IosResp(water={}, fog_gun={})


@summary("首页-今日数据-扬尘")
async def post_index_today_info(req, body: DeReq) -> ItiResp:
    cid = body.cid
    # return await index_today_info_service(cid)
    return ItiResp(pm2_5={}, pm10={}, tsp={}, today_water=0, today_kwh=0)


@summary("首页-运行趋势-喷淋")
async def post_index_water_stati(req, body: WsStatiReq) -> WsStatiResp:
    start = body.start
    end = body.end
    date_type = body.date_type
    # return await index_water_service(start, end, date_type)
    return WsStatiResp(pm2_5=[], pm10=[], tsp=[], water_or_electric=[], slots=[])


@summary("首页-运行趋势-雾炮")
async def post_index_wave_stati(req, body: WsStatiReq) -> WsStatiResp:
    cid = body.cid
    start = body.start
    end = body.end
    # return await index_electric_service(cid, start, end)
    return WsStatiResp(pm2_5=[], pm10=[], tsp=[], water_or_electric=[], slots=[])
