from pot_libs.mysql_util.mysql_util import MysqlUtil
from pot_libs.logger import log


async def get_apply_trial_by_data(name, email, company, phone, product):
    sql = "select id from apply_trial where name=%s and email=%s and " \
          "company=%s and phone=%s and product=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(name, email, company, phone,
                                              product))
    return data


async def save_apply_trial_by_data(name, email, company, phone, product):
    """插入数据"""
    sql = """INSERT INTO `apply_trial` (`name`, `email`, `company`, 
       `phone`, `product`) VALUES ( %s, %s, %s, %s, %s);"""
    async with MysqlUtil() as conn:
        await conn.execute(sql, args=(name, email, company, phone, product))
        log.info(sql % (name, email, company, phone, product))

