# -*- coding:utf-8 -*-
from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, Int, Str, Opt
from pot_libs.common.components.fields import DateTime


@dataclass
class QueryDetails(Model):
    cid: Cid


@dataclass
class ProductReq(Model):
    product: int = Int("产品类型").eg("6-智电U")
    cid: int = Opt(Int("工厂id").eg(66))
    proxy_id: int = Opt(Int("代理id").eg(66))


@dataclass
class HealthIndexResp(Model):
    health_index: float = Float("用电健康指数").eg(94)


@dataclass
class HealthRadarResp(Model):
    """健康指数雷达(评分)"""

    v_dev: int = Int("电压偏差评分")
    freq_dev: int = Int("频率偏差评分")
    ubl: int = Int("三相[电压]不平衡评分")
    costtl: int = Int("功率因数评分")
    thdu: int = Int("谐波畸变评分")
    lf: int = Int("负载率评分")


@dataclass
class HealthCtlRateRes(Model):
    """健康参数达标率"""

    real_time: DateTime = DateTime
    lf: float = Float("负载率达标率")
    costtl: float = Float("功率因数达标率")
    thdu: float = Float("谐波畸变达标率")
    v_dev: float = Float("电压偏差达标率")
    freq_dev: float = Float("频率偏差达标率")
    ubl: float = Float("三相[电压]不平衡达标率")


@dataclass
class ManageHealthIndexReq(Model):
    product: int = Int("产品类别1-知电 2-安电 3-安电U管理版").eg(3)
    proxy_id: int = Opt(Int("代理id").eg(1))


@dataclass
class ManageHealthIndexResp(Model):
    excellent_cnt: int = Int("优秀级别的工厂个数").eg(4)
    good_cnt: int = Int("良好的工厂个数").eg(3)
    fair_cnt: int = Int("及格的工厂个数").eg(5)
    bad_cnt: int = Int("差的工厂个数").eg(1)
