import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "storeys": [100, 101]
    }
])
@pytest.mark.asyncio
async def test_drop_dust(data):
    """
    降尘措施-卡片信息
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/drop-dust",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["res_data"]


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_id": 428,
        "start": "2021-04-22 00:00:00",
        "end": "2021-04-22 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_drop_dust_wave(data):
    """
    降尘措施-雾炮-运行曲线
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/drop-dust-wave",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["slots"]


@pytest.mark.parametrize('data', [
    {
        "cid": 73,
        "point_id": 231,
        "start": "2021-04-22 00:00:00",
        "end": "2021-04-22 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_drop_water_wave(data):
    """
    降尘措施-喷淋-运行曲线
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/drop-water-wave",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]


@pytest.mark.parametrize('data', [
    {"cid": 117},
])
@pytest.mark.asyncio
async def test_index_run_monit(data):
    """
    首页-运行监测-统计
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/index-run-monit",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["water"], resp_str["data"]["fog_gun"]])


@pytest.mark.parametrize('data', [
    {"cid": 117},
])
@pytest.mark.asyncio
async def test_index_op_stat(data):
    """
    首页-运行统计-扬尘
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/index-op-stat",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["water"], resp_str["data"]["fog_gun"]])


@pytest.mark.parametrize('data', [
    {"cid": 117},
])
@pytest.mark.asyncio
async def test_index_today_info(data):
    """
    首页-今日数据-扬尘
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/index-today-info",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["pm2_5"], resp_str["data"]["pm10"],
                resp_str["data"]["tsp"], resp_str["data"]["today_water"],
                resp_str["data"]["today_kwh"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "date_type": "day",
        "start": "2021-06-30 00:00:00",
        "end": "2021-06-30 23:59:59"
    },
    {
        "cid": 44,
        "date_type": "month",
        "start": "2021-06-01 00:00:00",
        "end": "2021-06-30 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_index_water_stati(data):
    """
    首页-运行趋势-喷淋
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/index-water-stati",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["pm2_5"], resp_str["data"]["slots"],
                resp_str["data"]["water_or_electric"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "date_type": "day",
        "start": "2021-06-30 00:00:00",
        "end": "2021-06-30 23:59:59"
    },
    {
        "cid": 44,
        "date_type": "month",
        "start": "2021-06-01 00:00:00",
        "end": "2021-06-30 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_index_wave_stati(data):
    """
    首页-运行趋势-雾炮
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/tsp-water/drop-dust/index-wave-stati",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["pm2_5"], resp_str["data"]["slots"],
                resp_str["data"]["water_or_electric"]])
