import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.asyncio
async def test_user_side_energy():
    """
    用户侧储能-默认数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/energy-optimize/energy-opt"
            f"/user-side-energy",
        data="",
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["cell_price"], resp_str["data"]["pcs_price"],
                resp_str["data"]["decay_rate"], resp_str["data"]["dod"],
                resp_str["data"]["year_use_days"],
                resp_str["data"]["charge_c_rate"]])


@pytest.mark.parametrize('data', [
    {
        "inline_id": 17,
        "cell_price": 2000,
        "pcs_price": 300,
        "other_ttl_charge": 0,
        "pcs_efficiency": 95,
        "bat_efficiency": 95,
        "decay_rate": 5,
        "dod": 90,
        "year_use_days": 330,
        "charge_c_rate": 0.8
    },
])
@pytest.mark.asyncio
async def test_user_side_analyzed(data):
    """
    用户侧储能-查看分析结果
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/energy-optimize/energy-opt"
            f"/user-side-analyzed",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["message"]


@pytest.mark.asyncio
async def test_distributed_photovoltaic():
    """
    分布式光伏-默认数据
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/energy-optimize/energy-opt"
            f"/distributed-photovoltaic",
        data="",
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["local_subsidy"],
                resp_str["data"]["local_subsidy_year"],
                resp_str["data"]["sel_use_per_kwh"],
                resp_str["data"]["self_use_price_discout"],
                resp_str["data"]["rmb_per_wp"],
                resp_str["data"]["self_use_ratio"]])


@pytest.mark.parametrize('data', [
    {
        "inline_id": 17,
        "install_space": 100,
        "self_use_ratio": 70,
        "rmb_per_wp": 7.5,
        "sel_use_per_kwh": 0.8,
        "self_use_price_discout": 10,
        "first_install_subsidy": 0,
        "local_subsidy": 0.25,
        "local_subsidy_year": 5
    },
])
@pytest.mark.asyncio
async def test_distributed_photovoltaic_analyzed(data):
    """
    分布式光伏-查看分析结果
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/energy-optimize/energy-opt"
            f"/distributed-photovoltaic-analyzed",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["install_cap"],
                resp_str["data"]["invest_evaluate"],
                resp_str["data"]["opt_analysis"],
                resp_str["data"]["capacity_scale_chart"]])
