from dataclasses import dataclass
from pot_libs.sanic_api.column import Int, Str, List, Opt
from pot_libs.sanic_api import Model
from unify_api.utils.response_code import DbErr, UserErr, JwtErr


@dataclass()
class UserInfoResponse(Model, DbErr, UserErr, JwtErr):
    user_id: int = Int('用户id').eg(80)
    nick_name: str = Str('昵称').eg("微信昵称")
    head_image_url: str = Str('头像地址').eg("http://abcweixin")
    real_name: str = Str('姓名').eg("张三")
    unit: str = Str('单位').eg("汇云中心")
    product_list: list = List("产品信息: 1-知电U+, 2-安电U+, 3-安电U+管理版").eg([1, 2, 3])
    zhiweiu_auth: int = Int('用户权限:1-普通用户,2-运维用户').eg(1)


@dataclass()
class SendSMSReq(Model):
    phone: str = Str('手机号').eg("13803838438")


@dataclass()
class SaveUserReq(Model):
    real_name: str = Str('姓名').eg("张三")
    unit: str = Str('公司').eg("清科优能")
    job: str = Str('职位').eg("程序猿")
    phone: str = Str('手机号').eg("13803838438")
    password: str = Str('密码').eg("13803838438")
    password2: str = Str('确认密码').eg("13803838438")
    verify: str = Opt(Str('当用手机号登录必传').eg("124567"))
    wechat_id: str = Opt(Str('当用微信登录必传').eg("041u75000YISfM1BDJ300KsbU"))


@dataclass()
class UpdatePhoneReq(Model):
    user_id: str = Str('用户id').eg("10086")
    phone: str = Str('手机号').eg("13803838438")
    verify: str = Str('验证码').eg("124567")


@dataclass()
class AuthPhoneReq(Model):
    phone: str = Str('手机号').eg("13803838438")
    verify: str = Str('验证码').eg("124567")


@dataclass()
class UserinfoReq(Model):
    user_id: str = Str('用户id').eg("10086")


@dataclass()
class UpdateWechatReq(Model):
    user_id: str = Str('用户id').eg("10086")
    code: str = Str('code').eg("")


@dataclass()
class UserinfoResp(Model):
    user_id: str = Str('用户id').eg("10086")
    name: str = Opt(Str('姓名').eg("张三"))
    phone: str = Str('手机号').eg("13803838438")
    unit: str = Str('公司').eg("10086")
    job: str = Str('职业').eg("10086")
    is_wechat: int = Int('是否绑定微信 1 绑定   0未绑定').eg(1)


@dataclass()
class UpdateUserInfoReq(Model):
    user_id: str = Str('用户id').eg("10086")
    name: str = Opt(Str('姓名').eg("张三"))
    unit: str = Opt(Str('公司').eg("10086"))
    job: str = Opt(Str('职业').eg("10086"))


@dataclass()
class UpdatePasswordReq(Model):
    phone: str = Str('手机号').eg("13803838438")
    password: str = Str('密码').eg("13803838438")
    password2: str = Str('密码2').eg("13803838438")


@dataclass()
class PhoneIsHavingReq(Model):
    phone: str = Str('手机号').eg("13803838438")
