from pot_libs.sanic_api import summary
from unify_api.modules.shidianu.components.open_data_cps import (
    BasicInfoReq, BasicInfoResp, StbDataReq, StbDataResp, SupplementReq
)
from unify_api.modules.alarm_manager.components.list_alarm import \
    ListAlarmResponse
from unify_api.modules.shidianu.service.open_data_service import \
    basic_info_longgang_service, stb_data_longgang_service, \
    supplement_data_service, result_longgang_service


# 数据对外开放接口
@summary("获取装置列表")
async def post_basic_info_longgang2(req, body: BasicInfoReq) -> BasicInfoResp:
    user_id = req.ctx.user_id
    # user_id = 10086
    page_size = body.page_size or 10
    page_num = body.page_num or 1
    return await basic_info_longgang_service(user_id, page_size, page_num)


@summary("查询数据")
async def post_stb_data_longgang2(req, body: StbDataReq) -> StbDataResp:
    user_id = req.ctx.user_id
    # user_id = 10086
    # cid = body.cid
    type = body.type
    return await stb_data_longgang_service(user_id, type)


@summary("获取告警结果")
async def post_alarm_result_longgang2(req, body: BasicInfoReq) -> \
        ListAlarmResponse:
    user_id = req.ctx.user_id
    # user_id = 10086
    page_size = body.page_size or 10
    page_num = body.page_num or 1
    importance = [2, 3]
    return await result_longgang_service(user_id, importance, page_size,
                                         page_num)


@summary("获取分析结果")
async def post_analyse_result_longgang2(req, body: BasicInfoReq) -> \
        ListAlarmResponse:
    user_id = req.ctx.user_id
    # user_id = 10086
    page_size = body.page_size or 10
    page_num = body.page_num or 1
    importance = [1]
    return await result_longgang_service(user_id, importance, page_size,
                                         page_num)


@summary("补充数据")
async def post_supplement_data(req, body: SupplementReq) -> StbDataResp:
    user_id = req.ctx.user_id
    # user_id = 10086
    cid = body.cid
    start = body.start
    end = body.end
    type = body.type
    return await supplement_data_service(user_id, cid, start, end, type)