from pot_libs.sanic_api import summary
from unify_api.modules.scope_analyse.components.scope_analyse_cps import \
    ScopeRecordReq, ScopeRecordResp, ScopeAnalyseReq, ScopeAnalyseResp,\
    LeakageCurrentResp
from unify_api.modules.scope_analyse.service.scope_analyse_service import *


# 故障诊断-诊断记录
@summary('故障诊断-诊断记录')
async def post_scope_record(req, body: ScopeRecordReq) -> ScopeRecordResp:
    cid = body.cid
    point_id = body.point_id
    start = body.start
    end = body.end
    page_size = body.page_size
    page_num = body.page_num
    return await scope_record_service(cid, point_id, page_num, page_size, start, end)


# 故障诊断-波形分析
@summary('故障诊断-波形分析')
async def post_scope_analyse(req, body: ScopeAnalyseReq) -> ScopeAnalyseResp:
    scope_id = body.scope_id
    return await scope_analyse_service(scope_id)


# 故障诊断-波形分析-漏电流
# @summary('故障诊断-波形分析-漏电流')
# async def post_search_leakage_current(req, body: ScopeAnalyseReq) -> \
#         LeakageCurrentResp:
#     scope_id = body.scope_id
#     return await search_leakage_current_service(scope_id)
