from pot_libs.mysql_util.mysql_util import MysqlUtil


async def get_kwh_p_dao(terms, start_time, end_time,
                        table_name="company_15min_power",
                        time_fmt="%%Y-%%m-%%d"):
    """
    负荷实际数据
    :param terms:
    :param start_time:
    :param end_time:
    :param table_name:
    :param time_fmt:
    :return:
    """
    
    sql = f"""
        select p,kwh,DATE_FORMAT(create_time,"{time_fmt}") as cal_time
        from {table_name} where cid in %s and create_time >= %s
        and create_time <= %s
    """
    async with MysqlUtil() as conn:
        result = await conn.fetchall(sql, args=(terms, start_time, end_time))
    return result or []


async def get_pred_p_dao(terms, start_time, end_time,
                         time_fmt="%%Y-%%m-%%d"):
    """
    负荷预测数据
    :param terms:
    :param start_time:
    :param end_time:
    :param time_fmt:
    :return:
    """
    sql = f"""
        select avg(p) p ,count(*) p_count,DATE_FORMAT(create_time,
        "{time_fmt}") as cal_time
        from company_day_ahead_predict
        where cid in %s and create_time >= %s  and create_time <= %s
        group by cal_time
    """
    async with MysqlUtil() as conn:
        result = await conn.fetchall(sql, args=(terms, start_time, end_time))
    return result or []
