from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Float, Str, Int, Opt


@dataclass
class ProxySecurityLevel(Model):
    high_cnt: int = Int("高风险的工厂个数").eg(20)
    pretty_high_cnt: int = Int("较高风险的工厂个数").eg(10)
    medium_cnt: int = Int("中等风险的工厂个数").eg(11)
    pretty_low_cnt: int = Int("较低风险的工厂个数").eg(1)
    security_cnt: int = Int("无风险的工厂个数").eg(78)


@dataclass
class AlarmContent(Model):
    temperature_cnt: int = Int("温度内容报警数目").eg(1)
    residual_current_cnt: int = Int("漏电流内容报警数目").eg(78)
    electric_param_cnt: int = Int("电参数内容报警数目").eg(78)


@dataclass
class ProxyElectricCountResp(Model):
    total_cid_cnt: int = Int("总用户数").eg(23)
    total_run_days: int = Int("总的运行天数").eg(67)
    total_safe_run_days: int = Int("安全运行天数").eg(12)
    security_level: ProxySecurityLevel = ProxySecurityLevel
    alarm_content: AlarmContent = AlarmContent


@dataclass
class ProxyElectricPageReq(Model):
    proxy_id: int = Int("代理id").eg(1)
    month: str = Str("月份").eg("2020-10")
    cids: list = List("公司id列表").items(Int("公司id")).eg([66, 73, 74])
    product: int = Int("产品 1-知电U 2-安电U 3-安电u管理版本 4-识电u")
    page_size: int = Opt(Int("一页多少条").eg(10))
    page_num: int = Opt(Int("第几页数据").eg(1))
    sort_field: str = Opt(
        Str("排序字段").eg("health_exp, volt_hr, curr_hr, ubl, ibl, volt_dev, freq_dev")
    )
    sort_direction: str = Opt(Str("排序方向").eg("desc, asc"))


@dataclass
class ProxyElectricPageItem(Model):
    company_name: str = Str("公司名称").eg("安电U演示工厂#1")
    electric_index: float = Float("安全指数").eg(78)
    first_alarm_cnt: int = Int("一级报警数").eg(56)
    second_alarm_cnt: int = Int("二级报警数").eg(78)
    third_alarm_cnt: int = Int("三级报警数").eg(44)
    electric_alarm_cnt: int = Int("电参数报警数").eg(44)
    temperature_alarm_cnt: int = Int("温度报警数").eg(60)
    residual_current_cnt: int = Int("漏电流报警数").eg(60)


@dataclass
class ProxyElectricPageResp(Model):
    total: int = Int("总条数").eg(28)
    rows: list = List("一页数据").items(ProxyElectricPageItem)
