# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/9
from pot_libs.sanic_api import summary, description
from pot_libs.utils.exc_util import BusinessException
from unify_api.constants import Product
from unify_api.modules.alarm_manager.components.alarm_static_cps import NlaReq, \
    WlaReq, LazReq
from unify_api.modules.alarm_manager.service.list_alarm_service import \
    new_list_alarm_service, wx_list_alarm_service, list_alarm_zdu_service, \
    wx_list_alarm_zdu_service, list_alarm_service
from unify_api.modules.common.procedures.cids import get_cid_info, get_cids, \
    get_proxy_cids
from unify_api.modules.users.procedures.jwt_user import jwt_user
from pot_libs.common.components.query import PageRequest
from unify_api.modules.alarm_manager.components.list_alarm import (
    ListAlarmResponse, ListAlarmReq,
    Alarm,
    list_alarm_example, WlazReq,
)


@summary("返回报警信息列表")
@description("筛选字段：监测点")
# @examples(list_alarm_example)
async def post_list_alarm(req, body: PageRequest) -> ListAlarmResponse:
    cid = req.json.get("cid")
    page_size = body.page_size
    page_num = body.page_num
    start, end = '', ''
    point_id = None
    alarm_type = []
    importance = []
    if body.filter.ranges:
        _range = body.filter.ranges[0]
        _, start, end = _range.field, _range.start, _range.end
    if body.filter.equals:
        for equal in body.filter.equals:
            if equal.field == 'cid':
                cid = equal.value
            elif equal.field == 'point_id':
                point_id = equal.value
    if body.filter.in_groups:
        for in_group in body.filter.in_groups:
            if in_group.field == 'type':
                alarm_type = in_group.group
            elif in_group.field == 'importance':
                importance = in_group.group
    cids = []
    if req.json.get("product") == Product.AndianUManage.value:
        proxy_id = req.json.get("proxy_id")
        product = req.json.get("product")
        user_id = jwt_user(req)
        req_cids = req.json.get("cids")

        # cids = await get_cids(user_id, product)
        proxy_cids = await get_proxy_cids(user_id, product, proxy_id)

        if req_cids and proxy_cids:
            cids = list(set(req_cids) & set(proxy_cids))
        else:
            cids = proxy_cids

    if req.json.get("product") in [Product.RecognitionElectric.value,
                                   Product.IntelligentU.value]:
        if not cid:
            product = req.json.get("product")
            user_id = jwt_user(req)
            cids = await get_cids(user_id, product)
        else:
            cids = [cid]
    if not cids and cid:
        cids = [cid]
    if not cids:
        raise BusinessException(message=f"你没有工厂权限")
    return await list_alarm_service(cids, point_id, start, end,
                                          importance, page_size, page_num,
                                          alarm_type)


@summary("报警记录-列表分页")
async def post_new_list_alarm(req, body: NlaReq) -> ListAlarmResponse:
    # 1. 获取参数
    cid = body.cid
    storeys = body.storeys
    page_num = body.page_num
    page_size = body.page_size
    start = body.start
    end = body.end
    product = body.product
    importance = body.importance
    point_ids = body.point_ids
    # 2. 调用service
    return await new_list_alarm_service(cid, storeys,
                                        (page_num - 1) * page_size, page_size,
                                        start, end, importance, point_ids,
                                        product)


@summary("小程序消息列表")
async def post_wx_list_alarm(req, body: WlaReq) -> ListAlarmResponse:
    # 1. 获取参数
    cids = body.cids
    product = body.product
    # 如果没有传start和end, 取最新40条, 传了start/end取范围内最新40条
    start = body.start
    end = body.end
    # 2. 调用service
    return await wx_list_alarm_service(cids, product, start, end)


@summary("报警记录-列表分页-智电u")
async def post_list_alarm_zdu(req, body: LazReq) -> ListAlarmResponse:
    # 1. 获取参数
    cid = body.cid
    point_list = body.point_list
    page_num = body.page_num
    page_size = body.page_size
    start = body.start
    end = body.end
    importance = body.importance
    event_type = body.event_type
    # 2. 调用service
    return await list_alarm_zdu_service(cid, point_list, page_num, page_size,
                                        start, end, importance, event_type)


@summary("小程序消息列表-智电u")
async def post_wx_list_alarm_zdu(req, body: WlazReq) -> ListAlarmResponse:
    # 1. 获取参数
    cid = body.cid
    point_list = body.point_list
    # 如果没有传start和end, 取最新100条, 传了start/end取范围内最新100条
    start = body.start
    end = body.end
    # 2. 调用service
    return await wx_list_alarm_zdu_service(cid, point_list, start, end)
