from pot_libs.mysql_util.mysql_util import MysqlUtil


async def post_update_alarm_emq_dao(set_id):
    """根据id查询alarm_setting表"""
    sql = "select * from soe_config_record where id=%s"
    async with MysqlUtil() as conn:
        alarm_dic = await conn.fetchone(sql, args=(set_id,))
    return alarm_dic


async def company_extend_dao(cid):
    """根据cid查询company_extend表"""
    sql = "select * from company_extend where cid=%s"
    async with MysqlUtil() as conn:
        event_dic = await conn.fetchall(sql, args=(cid,))
    return event_dic


async def list_alarm_data_dao(cid, point_list, page_num, page_size, start,
                              end, importance, event_type):
    sql = """select * from point_1min_event where pid in %s and 
    event_datetime>='%s' and  event_datetime <"%s" and importance in %s 
    and event_type in %s limit %s, %s"""
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(point_list, start, end,
                                              importance, event_type,
                                              (page_num-1)*page_size,
                                               page_size))
    return data


async def get_list_alarm_dao(mid_sql, page_size, page_num):
    start = (page_num-1)*page_size
    sql = f"SELECT point_1min_event.*, company.fullname " \
          f"FROM `point_1min_event` LEFT JOIN company " \
          f"on company.cid=point_1min_event.cid where {mid_sql} " \
          f"order by event_datetime desc " \
          f"limit {start}, {page_size}"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql)
    return data


async def get_total_list_alarm_dao(mid_sql):
    sql = f"SELECT count(id) total FROM `point_1min_event` where {mid_sql}"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql)
    return data["total"]
