# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/9
from dataclasses import dataclass

from pot_libs.common.components.fields import Item, DateTime
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Str, Float, Opt
from unify_api.utils.response_code import DbErr


@dataclass
class AdioHistory(Model):
    item: Item = Item
    value_slots: list = List('数值').items(Float())
    threhold: float = Opt(Float().eg(30))


@dataclass
class AdioHistoryResponse(Model, DbErr):
    temperature: list = List().items(AdioHistory)
    residual_current: list = List().items(AdioHistory)
    time_slots: list = List('时间轴').items(Str('时间'))


@dataclass
class AdioCurrent(Model):
    type: str = Str('location.type[temperature|residual_current]').eg(
        'temperature')
    item: Item = Item
    real_time: DateTime = DateTime
    value: float = Float('adio实时数值')


@dataclass
class AdioCurrentResponse(Model, DbErr):
    temperature: list = List('温度列表').items(AdioCurrent)
    residual_current: list = List('漏电流列表').items(AdioCurrent)


@dataclass
class AdioIndex(Model):
    type: str = Str('location.type[temperature|residual_current]').eg(
        'temperature')
    item: Item = Item
    max: float = Float('最大值')
    max_time: DateTime = DateTime
    min: float = Float('最小值')
    min_time: DateTime = DateTime
    avg: float = Float('平均值')


@dataclass
class AdioIndexResponse(Model, DbErr):
    adio_indexes: list = List('指标统计列表').items(AdioIndex)


adio_history_example = {
    "范例1": {
        "page_size": 20,
        "page_num": 1,
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 127
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-07-22 00:00:00",
                    "end": "2020-07-22 23:59:59"
                }
            ],
            "in_groups": [
                {
                    "field": "location_id",
                    "group": [
                        133, 134, 135
                    ]
                }
            ]
        },
        "sort": {
            "field": "datetime",
            "direction": "desc"
        }
    }
}

adio_current_example = {
    "范例1": {
        "filter": {
            "equals": [],
            "ranges": [],
            "in_groups": [
                {
                    "field": "location_id",
                    "group": [
                        259, 260, 261, 262, 263
                    ]
                }
            ]
        }
    }
}

adio_index_example = {
    "范例1": {
        "page_size": 20,
        "page_num": 1,
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 175
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-07-22 00:00:00",
                    "end": "2020-07-22 23:59:59"
                }
            ],
            "in_groups": [
                {
                    "field": "location_id",
                    "group": [
                        259, 260, 261, 262, 263
                    ]
                }
            ]
        },
        "sort": {
            "field": "datetime",
            "direction": "desc"
        }
    }
}
