# -*- coding:utf-8 -*-

class DBException(Exception):
    """include all type db exception"""
    status_code = 50001
    message = "数据库操作失败!"

    def __init__(self, *args, status_code=50001, message="数据库操作失败!", **kwargs):
        self.status_code = status_code
        self.message = message


class ParamException(Exception):
    """include all type param exception"""
    status_code = 50003
    message = "参数错误!"

    def __init__(self, *args, status_code=50003, message="参数错误!", **kwargs):
        self.status_code = status_code
        self.message = message


class BusinessException(Exception):
    """
    业务异常, 比如装置点被拆了mid为None这种情况, 但是在页面端point_id又可选择
    """
    status_code = 50007
    message = "业务错误!"

    def __init__(self, *args, status_code=50007, message="业务错误!", **kwargs):
        self.status_code = status_code
        self.message = message
