# /usr/bin/env python
# -*- coding: UTF-8 -*-

from pylab import plot, figure, show, subplot
import numpy as np


def pos_neg_zero(ia, ib, ic, ua, ub, uc,ctnum):
    rst = {}
    alpha = np.complex(-0.5, np.sqrt(3.0) / 2.0)
    alpha2 = alpha * alpha
    if ctnum==3:
        ua_pos = (ua + alpha * ub + alpha2 * uc) / 3.0
        ua_neg = (ua + alpha2 * ub + alpha * uc) / 3.0
        ua_zero = (ua + ub + uc) / 3.0

        ia_pos = (ia + alpha * ib + alpha2 * ic) / 3.0
        ia_neg = (ia + alpha2 * ib + alpha * ic) / 3.0
        ia_zero = (ia + ib + ic) / 3.0

        rst["ia_pos"] = ia_pos
        rst["ia_neg"] = ia_neg
        rst["ia_zero"] = ia_zero

        rst["ib_pos"] = alpha2 * ia_pos
        rst["ib_neg"] = alpha * ia_neg
        rst["ib_zero"] = ia_zero

        rst["ic_pos"] = alpha * ia_pos
        rst["ic_neg"] = alpha2 * ia_neg
        rst["ic_zero"] = ia_zero

        rst["ua_pos"] = ua_pos
        rst["ua_neg"] = ua_neg
        rst["ua_zero"] = ua_zero

        rst["ub_pos"] = alpha2 * ua_pos
        rst["ub_neg"] = alpha * ua_neg
        rst["ub_zero"] = ua_zero

        rst["uc_pos"] = alpha * ua_pos
        rst["uc_neg"] = alpha2 * ua_neg
        rst["uc_zero"] = ua_zero
    else:
        ua_pos = (ua-alpha2*ub) / 3.0
        ua_neg = (ua + alpha2*ub) / 3.0

        ia_pos = (ia-alpha2*ib) / 3.0
        ia_neg = (ia + alpha2*ib) / 3.0

        rst["ia_pos"] = ia_pos
        rst["ia_neg"] = ia_neg

        rst["ib_pos"] = alpha2 * ia_pos
        rst["ib_neg"] = alpha * ia_neg

        rst["ic_pos"] = alpha * ia_pos
        rst["ic_neg"] = alpha2 * ia_neg

        rst["ua_pos"] = ua_pos
        rst["ua_neg"] = ua_neg

        rst["ub_pos"] = alpha2 * ua_pos
        rst["ub_neg"] = alpha * ua_neg

        rst["uc_pos"] = alpha * ua_pos
        rst["uc_neg"] = alpha2 * ua_neg
    return rst


def convert(x, n_points_per,ctnum):
    len_data = len(list(x))
    rst = []
    angles=[]
    for i in range(len_data):
        if i > 80:
            x_fft = np.fft.fft(x[i - n_points_per:i]) * 2.0 / n_points_per
            x0 = np.abs(x_fft[1])
            phi0 = np.angle(x_fft[1])
            angles.append(np.angle(x_fft[1]))
            rea1 = x0 * np.cos(phi0)
            image = x0 * np.sin(phi0)
        else:
            x_fft = np.fft.fft(x[0:n_points_per]) * 2.0 / n_points_per
            x0 = np.abs(x_fft[1])
            phi0 = np.angle(x_fft[1])
            angles.append(np.angle(x_fft[1]))
            rea1 = x0 * np.cos(phi0 + 2.0 * np.pi * i / n_points_per)
            image = x0 * np.sin(phi0 + 2.0 * np.pi * i / n_points_per)
        rst.append(np.complex(rea1, image))

    return np.array(rst),angles


def dep_res(data, ctnum):
    cov_dict={}
    angles={}
    if ctnum == 3:
        cov_dict['cov_ia'],angles['ia'] = convert(data["ia"], 80,ctnum)
        cov_dict['cov_ib'],angles['ib'] = convert(data["ib"], 80,ctnum)
        cov_dict['cov_ic'],angles['ic'] = convert(data["ic"], 80,ctnum)
        cov_dict['cov_ua'],angles['ua'] = convert(data["ua"], 80,ctnum)
        cov_dict['cov_ub'],angles['ub'] = convert(data["ub"], 80,ctnum)
        cov_dict['cov_uc'],angles['uc'] = convert(data["uc"], 80,ctnum)
        dep_final = pos_neg_zero(cov_dict['cov_ia'], cov_dict['cov_ib'],  cov_dict['cov_ic'],cov_dict['cov_ua'], cov_dict['cov_ub'],  cov_dict['cov_uc'],ctnum)
    else:
        cov_dict['cov_iab'],angles['iab'] = convert(data["iab"], 80,ctnum)
        cov_dict['cov_ibc'],angles['ibc'] = convert(data["ibc"], 80,ctnum)
        cov_dict['cov_uab'],angles['uab'] = convert(data["uab"], 80,ctnum)
        cov_dict['cov_ubc'],angles['ubc'] = convert(data["ubc"], 80,ctnum)

        dep_final = pos_neg_zero(cov_dict['cov_iab'], cov_dict['cov_ibc'], 0,cov_dict['cov_uab'], cov_dict['cov_ubc'],0,ctnum)
    return cov_dict,dep_final,angles


if __name__ == "__main__":
    fs = 4000.0
    ts = 1 / fs
    t = np.arange(0, 0.2, ts)
    t1 = np.arange(0, 0.1, ts)
    fz = 50.0

    ua = 1.2 * np.cos(2 * np.pi * fz * t)
    ub = np.cos(2 * np.pi * fz * t - 2.0 * np.pi / 3.0)
    uc = np.cos(2 * np.pi * fz * t + 2.0 * np.pi / 3.0)

    ua1 = 0.5 * np.cos(2 * np.pi * fz * t1)
    ub1 = 0.5 * np.cos(2 * np.pi * fz * t1 + 2.0 * np.pi / 3.0)
    uc1 = 0.5 * np.cos(2 * np.pi * fz * t1 - 2.0 * np.pi / 3.0)

    ua[400:] += ua1[:]
    ub[400:] += ub1[:]
    uc[400:] += uc1[:]

    x1 = np.linspace(0, 10 * np.pi, 400)
    ua1 = 0.5 * np.cos(x1)
    ub1 = 0.5 * np.cos(x1 + 2.0 * np.pi / 3)
    uc1 = 0.5 * np.cos(x1 - 2.0 * np.pi / 3)

    co_res_ua = convert(ua[:], 80)
    co_res_ub = convert(ub[:], 80)
    co_res_uc = convert(uc[:], 80)
    decop = pos_neg_zero(co_res_ua, co_res_ub, co_res_uc)

    figure(1)

    plot(decop["a_pos"])

    plot(decop["a_neg"])
    plot(decop["a_zero"])
    show()
    figure(2)

    plot(decop["b_pos"])

    plot(decop["b_neg"])
    plot(decop["b_zero"])
    show()
    figure(3)

    plot(decop["c_pos"])

    plot(decop["c_neg"])
    plot(decop["c_zero"])
    show()
