from pot_libs.mysql_util.mysql_util import MysqlUtil


async def equipment_operations_dao(sql):
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql)
    return data


async def total_equipment_operations_dao(sql):
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql)
    return data


async def monitor_by_cid_sid(cid, sid):
    sql = "SELECT * from monitor where cid = %s and sid = %s and demolished=0"
    async with MysqlUtil() as conn:
        monitor_dic = await conn.fetchone(sql, args=(cid, sid))
    return monitor_dic
