from pot_libs.sanic_api import summary, description
from unify_api.modules.shidianu.components.algorithm_cps import (
    AlgorithmOutput,
    AlgorithmInput, WcReq, WcResp, AbcResp, AbcReq,
)
from unify_api.modules.shidianu.procedures.analysis_result_service import \
    wave_curve_srv, alarm_behavior_curve_service
from unify_api.modules.shidianu.procedures.output_result import algorithm_result_to_front
from unify_api.utils.time_format import srv_time


@summary("识电U识别结果输出接口")
@description("识电U")
async def post_algorithm_output(req, body: AlgorithmInput) -> AlgorithmOutput:
    point_id = body.point_id
    req_date = body.req_date
    product_id = 4  # PRODUCT.get(req.host)
    user_id = req.ctx.user_id
    detail = body.detail
    return await algorithm_result_to_front(point_id, req_date, user_id, product_id, detail)


@summary("识电u-行为曲线")
async def post_wave_curve(req, body: WcReq) -> WcResp:
    point_id = body.point_id
    req_date = body.req_date
    product = body.product
    return await wave_curve_srv(point_id, req_date, product)


@summary("识电u-用电行为-近30天统计")
async def post_alarm_behavior_curve(req, body: AbcReq) -> AbcResp:
    point_id = body.point_id
    product = body.product
    now_date, timestamp = srv_time()
    req_date = now_date[:10]
    return await alarm_behavior_curve_service(point_id, req_date, product)


