import numpy as np


def timeCalc(time=""):
    startTime = time[0].split(" ")[1].split(":")
    endTime = time[1].split(" ")[1].split(":")
    startTimer = int(startTime[0]) + int(startTime[1]) / 60
    endTimer = int(endTime[0]) + int(endTime[1]) / 60
    timer = endTimer - startTimer

    return timer


def electQuar(stateDict="", stageComponent="", timestage="", type="",
              timeAll="", power=""):
    affects = [i for i in range(len(stageComponent)) if
               stageComponent[i] == type]
    equipQuar = []
    timerUse = []
    for each in affects:
        startIndex = timeAll.index(timestage[each][0])
        endIndex = timeAll.index(timestage[each][1])
        timerUse.append(timeCalc(time=timestage[each]))
        equipQuar.append(np.mean(power[startIndex:endIndex]) * timerUse[-1])

    stateDict[type[0]] = [equipQuar, timerUse]

    return stateDict


def twoQuar(stateDict={}, elems=[], onetype="", timeOccur="", timeAll="",
            power=""):
    if onetype == ["空调运行"]:
        pass
    elif onetype == ["电冰箱运行"]:
        if "电冰箱运行" in stateDict.keys():

            timer = timeCalc(time=timeOccur)
            totalQuar = np.mean(power[
                                timeAll.index(timeOccur[0]):timeAll.index(
                                    timeOccur[1])]) * timer
            refrigSingle = timer * stateDict["电冰箱运行"][0][-1] / \
                           stateDict["电冰箱运行"][1][-1]
            stateDict["电冰箱运行"][0].append(refrigSingle)
            stateDict["电冰箱运行"][1].append(timer)
            another = list(set(elems) - set(onetype))
            if another[0] not in stateDict.keys():
                if totalQuar - refrigSingle > 0:
                    stateDict[another[0]] = [[totalQuar - refrigSingle],
                                             [timer]]
                else:
                    stateDict[another[0]] = [[totalQuar * 0.1], [timer]]

            else:
                if totalQuar - refrigSingle > 0:
                    stateDict[another[0]][0].append(totalQuar - refrigSingle)
                    stateDict[another[0]][1].append(timer)
                else:
                    stateDict[another[0]][0].append(totalQuar * 0.1)
                    stateDict[another[0]][1].append(timer)
    elif onetype == ["电磁炉运行"]:
        pass
    elif onetype == ["热水器运行"]:
        pass
    elif onetype == ["电饭煲运行"]:
        pass

    return stateDict


def threeQuar(stateDict={}, elems="", onetype="", timeOccur="", timeAll="",
              power=""):
    if onetype == ["电冰箱运行", "空调运行"]:
        if "电冰箱运行" in stateDict.keys() and "空调运行" in stateDict.keys():

            timer = timeCalc(time=timeOccur)
            totalQuar = np.mean(power[
                                timeAll.index(timeOccur[0]):timeAll.index(
                                    timeOccur[1])]) * timer
            refrigSingle = timer * stateDict["电冰箱运行"][0][-1] / \
                           stateDict["电冰箱运行"][1][-1]
            aircondSingle = timer * stateDict["空调运行"][0][-1] / \
                            stateDict["空调运行"][1][-1]

            stateDict["电冰箱运行"][0].append(refrigSingle)
            stateDict["电冰箱运行"][1].append(timer)
            stateDict["空调运行"][0].append(aircondSingle)
            stateDict["空调运行"][1].append(timer)
            another = list(set(elems) - set(onetype))
            if another[0] not in stateDict.keys():
                if totalQuar - refrigSingle - aircondSingle > 0:
                    stateDict[another[0]] = [
                        [totalQuar - refrigSingle - aircondSingle], [timer]]
                else:
                    stateDict[another[0]] = [[totalQuar * 0.1], [timer]]

            else:
                if totalQuar - refrigSingle - aircondSingle > 0:
                    stateDict[another[0]][0].append(
                        totalQuar - refrigSingle - aircondSingle)
                    stateDict[another[0]][1].append(timer)
                else:
                    stateDict[another[0]][0].append(totalQuar * 0.1)
                    stateDict[another[0]][1].append(timer)
    elif onetype == ["电冰箱运行", "热水器运行"]:
        if "电冰箱运行" in stateDict.keys() and "热水器运行" in stateDict.keys():
            timer = timeCalc(time=timeOccur)
            totalQuar = np.mean(power[
                                timeAll.index(timeOccur[0]):timeAll.index(
                                    timeOccur[1])]) * timer
            refrigSingle = timer * stateDict["电冰箱运行"][0][-1] / \
                           stateDict["电冰箱运行"][1][-1]
            heaterSingle = timer * stateDict["热水器运行"][0][-1] / \
                           stateDict["热水器运行"][1][-1]

            stateDict["电冰箱运行"][0].append(refrigSingle)
            stateDict["电冰箱运行"][1].append(timer)
            stateDict["热水器运行"][0].append(heaterSingle)
            stateDict["热水器运行"][1].append(timer)
            another = list(set(elems) - set(onetype))
            if another[0] not in stateDict.keys():
                if totalQuar - refrigSingle - heaterSingle > 0:
                    stateDict[another[0]] = [
                        [totalQuar - refrigSingle - heaterSingle], [timer]]
                else:
                    stateDict[another[0]] = [[totalQuar * 0.1], [timer]]

            else:
                if totalQuar - refrigSingle - heaterSingle > 0:

                    stateDict[another[0]][0].append(
                        totalQuar - heaterSingle - refrigSingle)
                    stateDict[another[0]][1].append(timer)
                else:
                    stateDict[another[0]][0].append(totalQuar * 0.1)
                    stateDict[another[0]][1].append(timer)
    elif onetype == ["电冰箱运行", "电磁炉运行"]:
        if "电冰箱运行" in stateDict.keys() and "电磁炉运行" in stateDict.keys():

            timer = timeCalc(time=timeOccur)
            totalQuar = np.mean(power[
                                timeAll.index(timeOccur[0]):timeAll.index(
                                    timeOccur[1])]) * timer
            refrigSingle = timer * stateDict["电冰箱运行"][0][-1] / \
                           stateDict["电冰箱运行"][1][-1]
            electroSingle = timer * stateDict["电磁炉运行"][0][-1] / \
                            stateDict["电磁炉运行"][1][-1]

            stateDict["电冰箱运行"][0].append(refrigSingle)
            stateDict["电冰箱运行"][1].append(timer)
            stateDict["电磁炉运行"][0].append(electroSingle)
            stateDict["电磁炉运行"][1].append(timer)
            another = list(set(elems) - set(onetype))
            if another[0] not in stateDict.keys():
                if totalQuar - refrigSingle - electroSingle > 0:
                    stateDict[another[0]] = [
                        [totalQuar - refrigSingle - electroSingle], [timer]]
                else:
                    stateDict[another[0]] = [[totalQuar * 0.1], [timer]]
            else:
                if totalQuar - refrigSingle - electroSingle > 0:

                    stateDict[another[0]][0].append(
                        totalQuar - electroSingle - refrigSingle)
                    stateDict[another[0]][1].append(timer)
                else:
                    stateDict[another[0]][0].append(totalQuar * 0.1)
                    stateDict[another[0]][1].append(timer)
    return stateDict


def fourQuar(stateDict={}, elems="", onetype="", timeOccur="", timeAll="",
             power=""):
    if onetype == ["电冰箱运行", "空调运行", "电磁炉运行"]:
        if "电冰箱运行" in stateDict.keys() and "空调运行" in stateDict.keys() and "电磁炉运行" in stateDict.keys():
            timer = timeCalc(time=timeOccur)
            totalQuar = np.mean(power[
                                timeAll.index(timeOccur[0]):timeAll.index(
                                    timeOccur[1])]) * timer
            refrigSingle = timer * stateDict["电冰箱运行"][0][-1] / \
                           stateDict["电冰箱运行"][1][-1]
            aircondSingle = timer * stateDict["空调运行"][0][-1] / \
                            stateDict["空调运行"][1][-1]
            electroSingle = timer * stateDict["电磁炉运行"][0][-1] / \
                            stateDict["电磁炉运行"][1][-1]

            stateDict["电冰箱运行"][0].append(refrigSingle)
            stateDict["电冰箱运行"][1].append(timer)
            stateDict["空调运行"][0].append(aircondSingle)
            stateDict["空调运行"][1].append(timer)
            stateDict["电磁炉运行"][0].append(electroSingle)
            stateDict["电磁炉运行"][1].append(timer)
            another = list(set(elems) - set(onetype))
            if another[0] not in stateDict.keys():
                if totalQuar - refrigSingle - aircondSingle - electroSingle > 0:
                    stateDict[another[0]] = [[
                                                 totalQuar - refrigSingle - aircondSingle - electroSingle],
                                             [timer]]
                else:
                    stateDict[another[0]] = [[totalQuar * 0.1], [timer]]
            else:
                if totalQuar - refrigSingle - aircondSingle - electroSingle > 0:

                    stateDict[another[0]][0].append(
                        totalQuar - refrigSingle - aircondSingle - electroSingle)
                    stateDict[another[0]][1].append(timer)
                else:
                    stateDict[another[0]][0].append(totalQuar * 0.1)
                    stateDict[another[0]][1].append(timer)
    return stateDict


def electricProportion(stageComponent="stageComponent", timestage="timestage",
                       power="power_pa", timeAll="day_time"):
    equipClass = set([each2 for each in stageComponent for each2 in each])
    stateDict = {}
    flag = [0, 0, 0, 0, 0]
    statisResDict = {}
    if ["电冰箱运行"] in stageComponent:
        stateDict = electQuar(stateDict=stateDict,
                              stageComponent=stageComponent,
                              timestage=timestage, type=["电冰箱运行"],
                              timeAll=timeAll, power=power)
        flag[0] = 1
    if ["空调运行"] in stageComponent:
        stateDict = electQuar(stateDict=stateDict,
                              stageComponent=stageComponent,
                              timestage=timestage, type=["电冰箱运行"],
                              timeAll=timeAll, power=power)
        flag[1] = 1

    if ["电磁炉运行"] in stageComponent:
        stateDict = electQuar(stateDict=stateDict,
                              stageComponent=stageComponent,
                              timestage=timestage, type=["电磁炉运行"],
                              timeAll=timeAll, power=power)
        flag[2] = 1

    if ["热水器运行"] in stageComponent:
        stateDict = electQuar(stateDict=stateDict,
                              stageComponent=stageComponent,
                              timestage=timestage, type=["热水器运行"],
                              timeAll=timeAll, power=power)
        flag[3] = 1

    if ["电饭煲运行"] in stageComponent:
        stateDict = electQuar(stateDict=stateDict,
                              stageComponent=stageComponent,
                              timestage=timestage, type=["电饭煲运行"],
                              timeAll=timeAll, power=power)
        flag[4] = 1
    affects = [i for i in range(len(stageComponent)) if
               len(stageComponent[i]) == 2]
    for each in affects:
        if flag[0] == 1 and "电冰箱运行" in stageComponent[each]:
            stateDict = twoQuar(stateDict=stateDict,
                                elems=stageComponent[each], onetype=["电冰箱运行"],
                                timeOccur=timestage[each], timeAll=timeAll,
                                power=power)

    affects = [i for i in range(len(stageComponent)) if
               len(stageComponent[i]) == 3]
    for each in affects:
        if flag[0] == 1 and "电冰箱运行" in stageComponent[each] and "空调运行" in \
                stageComponent[each]:
            stateDict = threeQuar(stateDict=stateDict,
                                  elems=stageComponent[each],
                                  onetype=["电冰箱运行", "空调运行"],
                                  timeOccur=timestage[each], timeAll=timeAll,
                                  power=power)

    affects = [i for i in range(len(stageComponent)) if
               len(stageComponent[i]) == 4]
    for each in affects:
        if flag[0] == 1 and "电冰箱运行" in stageComponent[each] and "空调运行" in \
                stageComponent[each] and "电磁炉运行" in stageComponent[each]:
            stateDict = fourQuar(stateDict=stateDict,
                                 elems=stageComponent[each],
                                 onetype=["电冰箱运行", "空调运行", "电磁炉运行"],
                                 timeOccur=timestage[each], timeAll=timeAll,
                                 power=power)
    statisResDict["电量与时长"] = stateDict
    statisResDict["波动"] = {"电冰箱": 60, "空调": 20, "电磁炉": 3, "热水器": 2}
    return statisResDict
