# -*- coding:utf-8 -*-
"""
DATE：2024/3/7 11:00

"""
from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, Str, List


@dataclass
class ContactsReq(Model):
    page_num: int = Int("页码").eg(1)
    page_size: int = Opt(Int("条数").eg(10))
    start_time: str = Opt(Str("起始时间").eg("2024-03-07 00:00:00"))
    end_time: str = Opt(Str("截止时间").eg("2023-12-29 18:06"))


@dataclass
class ContactInfo(Model):
    id: int = Opt(Int("ID").eg(1))
    user_name: str = Opt(Str("姓名").eg("ZZH"))
    tele: str = Opt(Str("电话号码").eg("10000"))
    email: str = Opt(Str("电子邮箱").eg("hu.jiayi@qkupower.com"))
    company: str = Opt(Str("公司名称").eg("清科优能"))
    msg: int = Opt(Str("留言").eg("来！一个电话、一个扫码，一个全新的合作机会！"))
    create_time: str = Str("时间").eg("2024-12-29 18:06")


@dataclass
class ContactsRsp(Model):
    total: int = Int("联系总数").eg(99)
    contacts: list = List("联系列表").items(ContactInfo)
