from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Int, Float, Opt, List


@dataclass
class MaxpResp(Model):
    maxp: float = Float("最大需量").eg(380.11)
    date_time: str = Str("时间点").eg("2020-05-07 18:30")


@dataclass
class DistributionReq(Model):
    cid: Cid
    start: str = Str("开始时间").eg("2020-09-01 00:00:00")
    end: str = Str("结束时间").eg("2020-09-30 23:59:59")
    inline_id: int = Int("进线id").eg(42)


@dataclass
class LrBins(Model):
    x: list = List("x坐标").eg(["<=0.05", "0.05-0.10", "0.10-0.15", "0.15-0.20"])
    y: str = Str("y值").eg([0.022, 0.0007, 0.0014, 0.0059])


@dataclass
class DistributionResp(Model):
    base_load: float = Float("基础负荷").eg(943.37)
    mean_load_rate: float = Float("平均负载率").eg(89.33)
    peak_valley: float = Float("峰谷差").eg(1855.51)
    max_load: MaxpResp = Opt(MaxpResp)
    lr_bins: LrBins = Opt(LrBins)
