from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Float, Str, Int


@dataclass
class InlineReq(Model):
    inline_id: int = Int("进线id").eg(74)


@dataclass
class MdSpaceResp(Model):
    time_slots: list = List("时间轴").items(Str("时间").eg("19年8月"))
    md_charge_values: list = List("需量").items(Float("需量电费").eg(5.96))
    tc_charge_values: list = List("容量").items(Float("容量电费").eg(5.96))
    inline_md_predict: float = Float("次月需量预测").eg(5.96)
    tc_runtime: float = Float("实际运行容量").eg(5000)
    price_md: float = Float("需量电价").eg(32)
    price_tc: float = Float("需量电价").eg(23)


@dataclass
class PowerFactorResp(Model):
    time_slots: list = List("时间轴").items(Str("时间").eg("19年8月"))
    power_factor_values: list = List("月功率因数").items(Float("功率因数").eg(0.96))
    power_factor: float = Float("上个月功率因数").eg(0.9)
    save_charge: float = Float("上个月节省的电费，单位万元").eg(1.7)
    punish_money: float = Float("功率因素理论罚款，单位元").eg(17)


@dataclass
class PeakCutValleyFillResp(Model):
    time_slots: list = List("时间轴").items(Str("时间").eg("19年8月"))
    pcvf_indexs: list = List("移峰填谷指数数组").items(Float("移峰填谷指数").eg(71))
    pcvf_index: float = Float("上个月移峰填谷指数").eg(71)
    avg_price: float = Float("上个月进线平均电价").eg(0.65)
    save_charge: float = Float("上个月节省的电费，单位万元").eg(1.7)
    price_f: float = Float("平段电价,单位元/kwh").eg(0.5)
    growth_percentage: float = Float("同比增长百分比").eg(40.11)


@dataclass
class PowerSaveResp(Model):
    time_slots: list = List("时间轴").items(Str("时间").eg("19年8月"))
    load_rates: list = List("月平均负载").items(Float("负载率").eg(71))
    avg_load_rate: float = Float("上月平均负载率").eg(70)
    save_charge: float = Float("上个月节省的电费，单位万元").eg(1.7)


