from unify_api.modules.elec_charge.common.utils import \
    aver_price, power_charge_download, load_power_charge, today_yesterday_load
from unify_api.modules.elec_charge.components.elec_statistics_cps import \
    SlotValue
from unify_api.utils.time_format import last_time_str
from unify_api.constants import CO2_N
from unify_api.modules.elec_charge.components.elec_statistics_cps import \
    PcStatiResp
from pot_libs.utils.pendulum_wrapper import my_pendulum
from unify_api.utils.common_utils import round_2


async def power_charge_stats_srv(cid, point_id, start, end, date_type):
    # 2. 如果是日统计,则需要增加今日/昨日负荷曲线, 15min一个点
    if date_type == "day":
        # 电量电费
        kwh_sv, charge_sv = await load_power_charge([cid], point_id, start,
                                                    end, date_type)
        # 智电u增加碳足迹 电量*0.754
        co2_slot = kwh_sv.slots
        co2_value = [round_2(i * CO2_N) if i else i for i in kwh_sv.value]
        co2_sv = SlotValue(slots=co2_slot, value=co2_value)
        # 需要增加15min电量电费
        kwh_sv_15min, charge_sv_15min = await power_charge_download(
            cid, point_id, start, end)
        # 今日/昨日负荷曲线
        today_p = await today_yesterday_load(cid, point_id, start, end)
        ysd_start, ysd_end = last_time_str(start, end, "day")
        yesterday_p = await today_yesterday_load(cid, point_id, ysd_start,
                                                 ysd_end)
        return PcStatiResp(kwh=kwh_sv, charge=charge_sv, today_p=today_p,
                           yesterday_p=yesterday_p, kwh_15min=kwh_sv_15min,
                           charge_15min=charge_sv_15min, co2=co2_sv)
    elif date_type == "month":
        # 本月电量电费, 平均电价
        kwh_sv, charge_sv = await load_power_charge([cid], point_id, start,
                                                    end, date_type)
        this_aver_price = aver_price(kwh_sv, charge_sv)
        # 智电u增加碳足迹 电量*0.754
        co2_slot = kwh_sv.slots
        co2_value = [round_2(i * CO2_N) if i else i for i in kwh_sv.value]
        co2_sv = SlotValue(slots=co2_slot, value=co2_value)
        # 上月电量电费, 平均电价
        last_start, last_end = last_time_str(start, end, "month")
        # 需要增加15min电量电费
        last_kwh_sv, last_charge_sv = await load_power_charge([cid], point_id,
                                                              last_start,
                                                              last_end,
                                                              date_type)
        last_aver_price = aver_price(last_kwh_sv, last_charge_sv)
        return PcStatiResp(kwh=kwh_sv, charge=charge_sv,
                           this_aver_price=this_aver_price,
                           last_aver_price=last_aver_price, co2=co2_sv)
    elif date_type == "year":
        # 本月电量电费
        kwh_sv, charge_sv = await load_power_charge([cid], point_id, start,
                                                    end, date_type)
        this_aver_price = aver_price(kwh_sv, charge_sv)
        return PcStatiResp(kwh=kwh_sv, charge=charge_sv,
                           this_aver_price=this_aver_price)
    else:
        start_f = my_pendulum.from_format(start, 'YYYY-MM-DD HH:mm:ss')
        end_f = my_pendulum.from_format(end, 'YYYY-MM-DD HH:mm:ss')
        diff_mm = (end_f - start_f).in_minutes()
        if diff_mm <= 48 * 60:
            # 自定义选时范围，不需要最后时间的数据，解决bug
            end = end_f.subtract(minutes=1).format("YYYY-MM-DD HH:mm:ss")
            # 电量电费
            kwh_sv, charge_sv = await load_power_charge([cid], point_id,
                                                        start, end, date_type)
            # 负荷曲线
            this_p = await today_yesterday_load(cid, point_id, start, end,
                                                is_range=1)
            # 需要增加15min电量电费
            kwh_sv_15min, charge_sv_15min = await power_charge_download(
                cid, point_id, start, end)
            return PcStatiResp(kwh=kwh_sv, charge=charge_sv, today_p=this_p,
                               kwh_15min=kwh_sv_15min,
                               charge_15min=charge_sv_15min)
        else:
            # 电量电费
            kwh_sv, charge_sv = await load_power_charge([cid], point_id,
                                                        start, end, date_type)
            # 平均电价
            this_aver_price = aver_price(kwh_sv, charge_sv)
            return PcStatiResp(kwh=kwh_sv, charge=charge_sv,
                               this_aver_price=this_aver_price)
