from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, List, Str, Opt, Int, Dict
from unify_api.utils.response_code import DbErr, ServerErr


@dataclass
class Spvf(Model):
    s: float = Float("尖期").eg(1000.123)
    p: float = Float("峰期").eg(1000.123)
    f: float = Float("平期").eg(1000.123)
    v: float = Float("谷期").eg(1000.123)


@dataclass
class PowerViewRes(Model):
    power: Spvf
    charge: Spvf


power_overview_example = {
    "范例1": {
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": -1
                },
                {
                    "field": "cid",
                    "value": 43
                }
            ],
            "ranges": [
                {
                    "field": "quarter_time",
                    "start": "2020-07-30 00:00:00",
                    "end": "2020-07-30 23:59:59"
                }
            ]
        }
    }
}


@dataclass
class PricePolicyReq(Model):
    cid: Cid


@dataclass
class PricePolicy(Model):
    term: str = Str("spfv -> 尖峰平谷").eg("s")
    period: list = List("收费时段").eg(["9:00-11:30", "14:00-16:30"])
    duration: float = Float("收费时长: 单位H").eg(9.1)
    ele_price: float = Float("电价").eg(1.05)


@dataclass
class PricePolicyResp(Model, DbErr):
    price_info: list = List("分时电价").items(PricePolicy)


@dataclass
class AverPriceReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(-1)
    date_type: str = Str("时间类型->day/month/year/range").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 15:00:00")


@dataclass
class ChargeKwh(Model):
    charge: float = Float("电费").eg(1000.11)
    kwh: float = Float("电量").eg(1000.11)


@dataclass
class AverPriceResp(Model):
    this_power: ChargeKwh = Opt(ChargeKwh)
    last_power: ChargeKwh = Opt(ChargeKwh)


@dataclass
class IndexChargeReq(Model):
    cid: Cid
    point_id: int = Int("point_id").eg(-1)


@dataclass
class IndexChargeResp(Model):
    today_spvf: PowerViewRes = Opt(PowerViewRes)
    month_spvf: PowerViewRes = Opt(PowerViewRes)
    today_power: AverPriceResp = Opt(ChargeKwh)
    month_power: AverPriceResp = Opt(ChargeKwh)


@dataclass
class PopReq(Model):
    cid_list: str = List("工厂列表").eg([32, 36])
    proxy_id: int = Int("代理id").eg(1)
    date_type: str = Str("时间类型->month/day/range").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")


@dataclass
class PopResp(Model):
    power: Spvf
    charge: Spvf
    this_power: float = Float("本周期总电量")
    this_charge: float = Float("本周期总电费")
    last_power: float = Float("上周期总电量")
    last_charge: float = Float("上周期总电费")
    power_rate: float = Float("电量增长率").eg(0.1)
    charge_rate: float = Float("电费增长率").eg(0.1)
    avg_price: float = Float("平均电价")
    price_rate: float = Float("电价增长率")


@dataclass
class MtpResp(Model):
    this_month_power: float = Float("本月用电")
    last_month_power: float = Float("上月用电")
    month_power_rate: float = Float("电量增长率").eg(0.1)
    this_day_power: float = Float("本月用电")
    last_day_power: float = Float("上月用电")
    day_power_rate: float = Float("电量增长率").eg(0.1)


@dataclass
class PspResp(Model):
    kwh: list = List("电量").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1, "rate": 0.012})
    charge: list = List("电费").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1, "rate": 0.012})
    price: list = List("电价").items(Dict()).eg(
        {"name": "工厂1", "value": 0.57, "rate": 0.012})


@dataclass
class IpspResp(Model):
    day_kwh: list = List("今日电量").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1})
    month_kwh: list = List("本月电量").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1})
    day_charge: list = List("今日电费").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1})
    month_charge: list = List("本月电费").items(Dict()).eg(
        {"name": "工厂1", "value": 100.1})
    day_price: list = List("今日电价").items(Dict()).eg(
        {"name": "工厂1", "value": 0.57})
    month_price: list = List("本月电价").items(Dict()).eg(
        {"name": "工厂1", "value": 0.57})


@dataclass
class KpReq(Model):
    cid: Cid
    storeys: list = List("楼层列表").eg([1, 2, 3])
    start: str = Str("开始时间").eg("2020-05-01 00:00:00")
    end: str = Str("结束时间").eg("2021-03-10 23:59:59")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class KpResp(Model):
    # kwh_data: list = List("电量").eg({"监测点": 10})
    kwh_data: list = List("电量").eg(
        [{"name": "89栋", "room_data": [{"room_name": "201", "value": 10.1}]}]
    )


@dataclass
class KclReq(Model):
    cid: Cid
    point_list: list = List().eg([439, 440, 441, 442, 443, 444, 445, 446, 447])
    start: str = Str("开始时间").eg("2021-05-01 00:00:00")
    end: str = Str("结束时间").eg("2021-05-27 23:59:59")


@dataclass
class ProductProxyReq(Model):
    product: int = Opt(Int("项目id"))
    proxy_id: int = Opt(Int("代理id, 当product是管理版3,5时 必传"))

@dataclass
class LoadInfoReq(Model):
    product: int = Opt(Int("项目id"))
    proxy_id: int = Opt(Int("代理id, 当product是管理版3,5时 必传"))

@dataclass
class LoadInfoResp(Model, DbErr, ServerErr):
    current_load: float = Opt(Float("今日实时负荷, 单位kW").eg(8263.2))
    yesterday_load: float = Opt(Float("昨日同时负荷, 单位kW").eg(8000))
    load_percent: float = Opt(Float("对比昨日，百分比").eg(1))
