from unify_api.modules.common.dao.common_dao import monitor_point_join, \
    monitor_location_join


async def monitor_map_point_location(cid):
    """cid下每个monitor包含的point和location"""
    # 1. point
    monitor_point_list = await monitor_point_join(cid)
    # monitor和point是1对1, 如果1对多改成和location一致
    monitor_point_dic = {m["mtid"]: m["pid"] for m in monitor_point_list}
    # 2. location
    monitor_location_list = await monitor_location_join(cid)
    monitor_location_dic = {}
    for m in monitor_location_list:
        mtid = m["mtid"]
        if mtid not in monitor_location_dic:
            monitor_location_dic[mtid] = [m["lid"]]
        else:
            monitor_location_dic[mtid].append(m["lid"])
    return monitor_point_dic, monitor_location_dic
