import json

from pot_libs.mysql_util.mysql_util import MysqlUtil
from unify_api.constants import Product


async def get_cid_info(company_ids=None, proxy_ids=None, all=False):
    """
    获取一个工厂的有效监测点
    :param company_id:
    :return: 返回{"pid": point_info}
    """
    if proxy_ids:
        company_sql = "select c.cid, cpm.proxy, c.shortname, c.fullname, " \
                      "c.longitude, c.latitude from company c " \
                      "inner join company_proxy_map cpm on cpm.cid=c.cid " \
                      "where cpm.proxy in %s"
        args = (proxy_ids,)
    elif company_ids:
        company_sql = "select c.cid,cpm.proxy,c.shortname,c.fullname," \
                      "c.longitude,c.latitude from company c inner join " \
                      "company_proxy_map cpm on cpm.cid=c.cid  " \
                      "where c.cid in %s"
        args = (company_ids,)
    else:
        company_sql = "select c.cid,cpm.proxy,c.shortname,c.fullname," \
                      "c.longitude,c.latitude from company c inner join " \
                      "company_proxy_map cpm on cpm.cid=c.cid"
        args = None

    async with MysqlUtil() as conn:
        companys = await conn.fetchall(company_sql, args=args)
        company_map = {i["cid"]: i for i in companys}
        return company_map


async def get_cids(user_id, product=Product.AndianUManage.value):
    """
    管理版本根据登录态user_id和product获取工厂ids
    :param user_id:
    :param product: 默认是3(管理版本)
    :return:
    """
    async with MysqlUtil() as conn:
        user_auth_sql = (
            "select product, cid_ext, proxy from user_product_auth where "
            "user_id=%s and product=%s"
        )
        user = await conn.fetchone(user_auth_sql, args=(user_id, product))
        cids_ext, cids_proxy, cids_super = [], [], []
        if not user:
            return []
        if user["cid_ext"]:
            cids_ext = [int(i) for i in json.loads(user["cid_ext"])]
        if user["proxy"] == '0':
            sql = "select cid from company where product=%s and is_show = 1"
            if product == Product.AndianUManage.value:
                product = Product.AnDianU.value
            if product == Product.ZhidianUManage.value:
                product = Product.ZhiDianU.value
            if product == Product.RecognitionElectricNew.value:
                product = Product.RecognitionElectric.value
            companys = await conn.fetchall(sql, args=(product,))
            cids_super = [i["cid"] for i in companys]
        elif user["proxy"]:
            company_sql = "select c.cid, p.proxy from company c " \
                          "LEFT JOIN company_proxy_map p on c.cid=p.cid " \
                          "where p.proxy=%s and c.product=%s and c.is_show = 1"
            if product == Product.AndianUManage.value:
                product = Product.AnDianU.value
            if product == Product.ZhidianUManage.value:
                product = Product.ZhiDianU.value
            if product == Product.RecognitionElectricNew.value:
                product = Product.RecognitionElectric.value
            companys = await conn.fetchall(company_sql, args=(user["proxy"], product))
            cids_proxy = [i["cid"] for i in companys]
        return list(set(cids_ext).union(cids_proxy, cids_super))


async def get_proxy_cids(user_id, product, proxy_id):
    """管理版本根据返回cids"""
    async with MysqlUtil() as conn:
        user_auth_sql = (
            "select product, cid_ext, proxy from user_product_auth where "
            "user_id=%s and product=%s"
        )
        user = await conn.fetchone(user_auth_sql, args=(user_id, product))
        cids_ext, cids_proxy = [], []
        if not user:
            return []
        if user["cid_ext"]:
            cids_ext = [int(i) for i in json.loads(user["cid_ext"])]
        c_sql = "SELECT cpm.proxy,c.cid FROM company c " \
                "left join company_proxy_map cpm on c.cid=cpm.cid " \
                "where cpm.proxy=%s and c.is_show=1 and c.product=%s"
        if product == Product.AndianUManage.value:
            product = Product.AnDianU.value
        if product == Product.ZhidianUManage.value:
            product = Product.ZhiDianU.value
        if product == Product.RecognitionElectricNew.value:
            product = Product.RecognitionElectric.value
        companys = await conn.fetchall(c_sql, args=(proxy_id, product))
        cids_proxy = [i["cid"] for i in companys]
        return list(set(cids_ext).union(cids_proxy))
