from pot_libs.logger import log
from unify_api.constants import REDUCE_CO2
from unify_api.utils.common_utils import round_2


def env_benefit_ca(conversion_year, energy_standard, total_area):
    """环境效益逻辑"""
    # 1. 若折算年 < 能耗标准，环境效益的文字显示为“相比能耗标准，
    # 节约用电XX万kWh，减少排放XX万kg二氧化碳，相当于多种XX棵树”；
    # 2. 若折算年 > 能耗标准，环境效益的文字显示为“超出能耗标准，请注意控制节能降耗”；
    # 3. 若折算年 = 能耗标准，环境效益的文字显示为“符合能耗标准，请继续保持”。
    if not all([conversion_year, energy_standard, total_area]):
        log.warning("能耗标准,折算年, 存在空值")
        return ""
    if conversion_year == energy_standard:
        return "符合能耗标准，请继续保持"
    elif conversion_year > energy_standard:
        return "超出能耗标准，请注意控制节能降耗"
    else:
        # 1. 节约用电, (能耗标准 - 折算年) * 总面积
        diff_kwh = (energy_standard - conversion_year)*total_area  # 节约用电int
        if diff_kwh > 10000:
            diff_kwh_str = str(round_2(diff_kwh / 10000)) + "万"
        else:
            diff_kwh_str = round_2(diff_kwh)
        # 2. 减少二氧化碳排放
        # 当用户节约1kWh电量时，减少碳排放0.2047kg；减少二氧化碳排放0.751kg
        reduce_c02 = round(diff_kwh * REDUCE_CO2)  # 减少二氧化碳排放
        if reduce_c02 > 10000:
            reduce_c02_str = str(round_2(reduce_c02 / 10000)) + "万"
        else:
            reduce_c02_str = round_2(reduce_c02)
        # 3. 植树折算
        """
        折算效益时，时间粒度为年则取18.3kg；
        时间粒度为月则取1.525kg；
        时间粒度为天则取0.05kg。
        测算时段内的二氧化碳排放量除以上述系数得到相当于种多少棵树
        """
        add_tree = round(reduce_c02 / 1.525)  # 多种XX棵树int
        # 多种数
        return f"低于能耗标准用电{diff_kwh_str}kWh，" \
               f"减少排放{reduce_c02_str}kg二氧化碳，" \
               f"相当于多种{add_tree}棵树"
