from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Str, Int, Float, Dict


@dataclass
class CiResp(Model):
    total_area: int = Int("总面积").eg(120000)
    total_kwh: float = Float("总能耗").eg(100000.23)
    energy_density: float = Float("能耗密度").eg(5.12)
    conversion_year: float = Float("折算年").eg(60.23)
    energy_standard: float = Float("能耗标准").eg(75.12)
    env_benefit: str = Str("环境效益").eg("符合能耗标准，请继续保持")


@dataclass
class TaResp(Model):
    working_day: dict = Dict("工作日").eg(
        {"slots": [], "values": [], "avg_power": 110.12}
    )
    non_working_day: dict = Dict("非工作日").eg(
        {"slots": [], "values": [], "avg_power": 110.12}
    )


@dataclass
class CeiResp(Model):
    carbon_index: int = Int("碳排指数").eg(62)
    carbon_status: str = Str("达标情况").eg("达标")
    conversion_year: float = Float("折算年").eg(60.23)
    energy_standard: float = Float("能耗标准").eg(75.12)
