from unify_api.modules.anshiu.procedures.equip_management_pds import \
    equip_run_list, equip_run_statistics
from unify_api.modules.anshiu.components.equip_management_cps import \
    EquipRunInfo
from unify_api.utils.time_format import get_time_duration, get_datetime_str, \
    get_date_timestamp, get_time_duration_by_str


async def equip_run_list_serv(company_id, point_ids, start_time, end_time,
                              page_num, page_size, sort_field, sort_type):
    '''
        获取运行统计列表
    '''
    start_time = get_date_timestamp(start_time)
    end_time = get_date_timestamp(end_time)
    rows, total = await equip_run_list(company_id, point_ids, start_time,
                                       end_time, page_num, page_size,
                                       sort_field, sort_type)
    run_lists = []
    for row in rows:
        run_time = get_time_duration(row['start_time'], row['end_time']) if \
            row['start_time'] and row['end_time'] else ''
        start_time_one = get_datetime_str(row['start_time']) if row[
            'start_time'] else ''
        end_time_one = get_datetime_str(row['end_time']) if row['end_time'] \
            else ''
        equip_run_info = EquipRunInfo(point_name=row['point_name'],
                                      start_time=start_time_one,
                                      end_time=end_time_one,
                                      run_time=run_time)
        run_lists.append(equip_run_info)
    return run_lists, total


async def equip_run_statistics_serv(company_id, point_ids, start_time,
                                    end_time):
    '''
        运行统计数据
    '''
    start_time = get_date_timestamp(start_time)
    end_time = get_date_timestamp(end_time)
    data = await equip_run_statistics(company_id, point_ids, start_time,
                                      end_time)
    data['all_time'] = get_time_duration_by_str(data['all_time']) if data[
        'total_count'] else ''
    data['avg_time'] = get_time_duration_by_str(data['avg_time']) if data[
        'total_count'] else ''
    data['max_time'] = get_time_duration_by_str(data['max_time']) if data[
        'total_count'] else ''
    return data
