# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/9
from dataclasses import dataclass

from pot_libs.common.components.fields import DateTime, Group, Item, Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Opt, Float
from unify_api.utils.response_code import DbErr


@dataclass
class Alarm(Model):
    date_time: DateTime
    importance: int = Int('告警级别').eg(2)  # 数据库对应importance
    name: str = Str('监测点名称').eg('母排A相')  # point直接取，location拼item
    type: str = Str('事件类型').eg('underU')
    type_name: str = Str('事件类型').eg('欠压')
    description: str = Str('描述').eg('负载率超过80%， 达到89%')
    redirect_type: str = Opt(Str('跳转类型').eg('scope | temp_trend'))
    es_id: str = Str('es_id').eg('180_over_gap_u_a_1594274674')
    url: str = Opt(Str(
        '查看详情,url 可选：【scope_details， temp_trend】'
    ).eg('/scope_details?doc_id={doc_id}'))
    event_duration: int = Int('持续时间').eg('7')
    company_name: str = Str('公司名').eg('广州ABC集团')
    point_id: int = Opt(Int('point_id').eg(245))
    storey_name: str = Opt(Str('storey名字').eg('264栋'))
    room_name: str = Opt(Str('room名字').eg('101'))
    storey_room_name: str = Opt(Str('storey+room名字').eg('264栋101'))
    content: str = Opt(Str('内容').eg('负载率超过80%， 达到89%'))
    sid: str = Opt(Str('设备id').eg('A2004000815'))
    mtid: int = Opt(Int('持续时间').eg('7'))


@dataclass
class ListAlarmResponse(Model, DbErr):
    total: int = Int('总量')
    point_ids: list = Opt(List('监测点id').eg([1, 2]))
    rows: list = List('报警信息').items(Alarm)


@dataclass
class ListAlarmReq(Model):
    cid: int = Int('cid')
    point_id: int = Opt(Int('监测点id 全部不传').eg(1))
    start: str = Opt(Str("开始时间").eg("2020-05-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-03-10 23:59:59"))
    importance: list = Opt(List('告警等级').eg([1, 2, 3]))
    page_size: int = Int('每页行数').eg(20)
    page_num: int = Int("当前请求页数").eg(1)
    alarm_type: list = Opt(List('告警类型').eg(["overI", "unbalanceU"]))


@dataclass
class QueryDetails(Model):
    doc_id: str = Str('es doc id')
    wave_range:str = Opt(Str('波形范围').eg('100ms | all'))


@dataclass
class ScopeContent(Model):
    ia: list = List().items(Int())
    ib: list = Opt(List().items(Int()))
    ic: list = List().items(Int())
    ua: list = Opt(List().items(Int()))
    ub: list = Opt(List().items(Int()))
    uc: list = Opt(List().items(Int()))
    uab: list = Opt(List().items(Int()))
    ucb: list = Opt(List().items(Int()))


@dataclass
class ScopeDetailsResponse(Model, DbErr):
    ctnum: int = Int('二表法 | 三表法').eg(3)
    group: Group = Group
    item: Item = Item
    type: str = Str().eg('电流波动')
    date_time: DateTime = DateTime
    location: int = Int('故障点')
    contents: ScopeContent = ScopeContent


@dataclass
class TempTrendResponse(Model, DbErr):
    group: Group = Group
    item: Item = Item
    date_time: str = Str('时间')
    description: str = Str('事件描述')
    time_slots: list = List('时间轴').items(Str('时间'))
    realtime: list = List('实时温度').items(Float())
    daily: list = List('日前预测').items(Float())
    quarterly: list = List('实时预测').items(Float())


list_alarm_example = {
    "范例1": {
        "page_size": 20,
        "page_num": 1,
        "filter": {
            "equals": [
                {
                    "field": "point_id",
                    "value": 128
                }
            ],
            "ranges": [
                {
                    "field": "datetime",
                    "start": "2020-05-02 17:32:31",
                    "end": "2020-07-03 17:32:31"
                }
            ],
            "in_groups": [
                {
                    "field": "location_id",
                    "group": [
                        136, 137, 138, 139, 140
                    ]
                },
                {
                    "field": "type",
                    "group": [
                        "over_gap_i",
                        "overResidualCurrent",
                    ]
                }
            ]
        },
        "sort": {
            "field": "datetime",
            "direction": "desc"
        }
    }
}

temp_trend_example = {
    "范例1": {
        "doc_id": "199_overTemp__1595237202"
    }
}

scope_details_example = {
    "范例1": {
        "doc_id": "180_over_gap_u_a_1594274674"
    }
}


@dataclass
class WlazReq(Model):
    cid: Cid
    point_list: list = List().eg([439, 440])
    start: str = Opt(Str("开始时间").eg("2020-05-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-03-10 23:59:59"))
