from pot_libs.mysql_util.mysql_util import MysqlUtil


async def get_location_dao(lids):
    location_info = {}
    sql = "SELECT lid, item, mtid, ad_type FROM location WHERE lid IN %s"
    async with MysqlUtil() as conn:
        result = await conn.fetchall(sql, args=(lids,))
        if result:
            for res in result:
                id = res.get("lid")
                item = res.get("item")
                type = res.get("ad_type")
                mtid = res.get("mtid")
                location_info[id] = {"item": item, "type": type, "mtid": mtid}
    return location_info


async def get_location_15min_dao(lid, start, end,
                                 table_name="location_15min_aiao"):
    sql = f"SELECT lid,value_max,value_max_time,value_avg,value_min," \
          f"value_min_time  FROM {table_name} WHERE lid = %s " \
          f"and create_time BETWEEN '{start}' and '{end}'"
    async with MysqlUtil() as conn:
        result = await conn.fetchall(sql, args=(lid,))
    return result
