import copy

from pot_libs.mysql_util.mysql_util import MysqlUtil


async def monitor_location_join_by_locations(locations):
    """monitor和location关联"""
    sql = "SELECT m.mtid, m.name, m.m_type, l.lid, l.item, l.ad_type " \
          "FROM monitor m inner join location l on m.mtid = l.mtid " \
          "WHERE l.lid in %s and m.demolished=0 order by field(l.lid,{})".\
        format(str(locations).replace("[", "").replace("]", ""))
    async with MysqlUtil() as conn:
        monitor_location_list = await conn.fetchall(
            sql, args=(tuple(locations),))
    return monitor_location_list


async def alarm_setting_by_locations(locations):
    """根据locations查询alarm_setting"""
    sql = "select lid, threshold from soe_config_record " \
          "where lid in %s " \
          "and `etype` in ('overTemp', 'overResidualCurrent')"
    async with MysqlUtil() as conn:
        alarm_setting_list = await conn.fetchall(sql, args=(tuple(locations),))
    return alarm_setting_list
