import json
import pytest
from unify_api.tests.constants_t import post_request


#  碳中和-统计概况信息
class TestCarbonSummary(object):
    url = "/unify-api/carbon-neutral/carbon-reduce/carbon-summary"

    @pytest.mark.parametrize('data', [{
        "cid": 54,   # 只有54和118 有数据
        "start": "2021-11-01 00:00:00",
        "end": "2021-11-30 23:59:59"}, {
        "cid": 118,
        "start": "2021-11-11 00:00:00",
        "end": "2021-12-31 23:59:59"}
    ])
    @pytest.mark.asyncio
    async def test_carbon_summary(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["total_area"] == 93960

    @pytest.mark.parametrize('data', [{
        "cid": 44,   # 只有54和118 有数据
        "start": "2021-11-01 00:00:00",
        "end": "2021-11-30 23:59:59"}, {
        "cid": 32,
        "start": "2020-11-11 00:00:00",
        "end": "2021-12-31 23:59:59"}
    ])
    @pytest.mark.asyncio
    async def test_carbon_summary_error_cid(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["total_area"] == ""


#  碳中和-趋势分
class TestTrendAnalysis(object):
    url = "/unify-api/carbon-neutral/carbon-reduce/trend-analysis"

    @pytest.mark.parametrize('data', [{
        "cid": 118,
        "start": "2021-11-01 00:00:00",
        "end": "2021-11-30 23:59:59"}, {
        "cid": 54,
        "start": "2021-11-11 00:00:00",
        "end": "2021-12-31 23:59:59"}
    ])
    @pytest.mark.asyncio
    async def test_trend_analysis(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["working_day"]["avg_power"], float)


#  碳中和-趋势分
class TestCarbonEmissionIndex(object):
    url = "/unify-api/carbon-neutral/carbon-reduce/carbon-emission-index"

    # 只有54和118 有数据
    @pytest.mark.parametrize('data', [{"cid": 54}, {"cid": 118}, {"cid": 54}])
    @pytest.mark.asyncio
    async def test_carbon_summary(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
