from dataclasses import dataclass
from pot_libs.common.components.fields import DateTime, Group, Item, Cid
from pot_libs.sanic_api.column import Str, Int, Opt, List
from pot_libs.sanic_api import Model
from unify_api.utils.response_code import DbErr


@dataclass
class ScopeDetailRep(Model):
    id: str = Opt(Str("报警id").eg("213_over_gap_i__1604302769"))
    wave_range: str = Opt(Str('波形范围').eg('100ms | all'))


@dataclass
class SearchScopeRep(Model):
    prod_id: int = Opt(Int("项目id").eg(4))
    cid: int = Opt(Int("客户id").eg(63))
    pid: int = Opt(Int("监测点id 0表示全部").eg(213))
    sid: str = Opt(Str("硬件编号").eg(""))
    start: str = Opt(Str("开始时间").eg("2021-07-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-07-01 23:59:59"))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)


@dataclass
class Alarm(Model):
    check_dt: str = Str("发生时间").eg("2021-07-01 23:59:59")
    prod_id: int = Int('项目id').eg(2)
    product: str = Str('项目名称').eg('知电U+')
    cid: int = Int('客户id').eg(2)
    shortname: str = Str('客户名称').eg('中洲滨海商业中心1栋')
    pid: int = Int('监测点id').eg(2)
    point: str = Str('监测点名称').eg('土建区总进线')
    sid: str = Str('硬件编号').eg('A1911000287')
    message: str = Str('触发原因').eg('B相电压波动')
    contin_time: int = Opt(Int('持续时间').eg(2))
    doc_id: str = Opt(Str('该条信息id').eg('213_over_gap_i__1604302769'))
    result: str = Opt(Str('结论分析').eg('xxxxxxxxx'))


@dataclass
class SearchScopeResq(Model):
    total: int = Int('总量')
    rows: list = List('报警信息').items(Alarm)


@dataclass
class ScopeContent(Model):
    ia: list = List().items(Int())
    ib: list = Opt(List().items(Int()))
    ic: list = List().items(Int())
    ua: list = Opt(List().items(Int()))
    ub: list = Opt(List().items(Int()))
    uc: list = Opt(List().items(Int()))
    uab: list = Opt(List().items(Int()))
    ucb: list = Opt(List().items(Int()))
    ileak: list = Opt(List("漏电流实际值").items(Int()))
    ileak_rms: list = Opt(List("漏电流有效值").items(Int()))


@dataclass
class ScopeDetailsResponse(Model, DbErr):
    alarm: Alarm = Alarm
    ctnum: int = Int('二表法 | 三表法').eg(3)
    group: Group = Group
    item: Item = Item
    scope_type: str = Opt(Str().eg('over_rms_i'))
    type: str = Opt(Str().eg('电流波动'))
    date_time: DateTime = Opt(DateTime)
    location: int = Opt(Int('故障点'))
    contents: ScopeContent = ScopeContent
