from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Str, Int, List


@dataclass
class ReceiveOrderReq(Model):
    id: int = Int('工单id').eg(1)


@dataclass
class ReceiveOrderResp(Model):
    id: int = Int('工单id').eg(1)


@dataclass
class FlowOrderReq(Model):
    id: int = Int('工单id').eg(1)
    user_id: int = Int('工单接收人id').eg(10086)
    explain: str = Str("备注说明").eg("xxxxxxxxxxxx")
    doc_ids: list = List("文件id").eg([2, 3, 4])


@dataclass
class WorkOrderReq(Model):
    id: int = Int('工单id').eg(1)
    explain: str = Str("备注说明").eg("xxxxxxxxxxxx")
    doc_ids: list = List("文件id").eg([2, 3, 4])


@dataclass
class AddOrderReq(Model):
    id: int = Opt(Int('工单id 修改工单必传').eg(1))
    order_num: str = Opt(Str('工单号 修改工单必传').eg("S21071515272612"))
    prod_id: int = Int('项目id').eg(1)
    cid: int = Int('id').eg(45)
    check_dt: str = Str("发生时间").eg("2021-04-22 00:00")
    sid: str = Opt(Str('硬件编号').eg('A1904000088'))
    point_id: int = Opt(Int('监测点id').eg(68))
    warn_info: str = Opt(Str("备注").eg("xxxxxxxxxxxx"))
    doc_ids: list = Opt(List("附件id").eg([21, 22]))


@dataclass
class SidToOrderReq(Model):
    sid: str = Str('硬件编号').eg('A2004000192')


@dataclass
class PidToSidReq(Model):
    pid: int = Int('监测点id').eg(68)


@dataclass
class SidToOrderResp(Model):
    data: list = List


@dataclass
class CidToSidResp(Model):
    sid: str = Str('硬件编号').eg('A2004000192')


@dataclass
class DeleteOrderFileReq(Model):
    id: int = Int('附件id').eg(1)

