from pot_libs.sanic_api import summary
from pot_libs.logger import log
from pot_libs.common.components.responses import Success
from unify_api.modules.qk_website.components.apply_trial_cps import \
    PageDataResp, ApplyTrialReq
from unify_api.modules.qk_website.service.apply_trial_services import \
    apply_trial_service


@summary('页面数据')
async def get_page_data(req) -> PageDataResp:
    return PageDataResp(electric_sum="210亿", risk_less="5000万",
                        c_emission_less="1260万", user_safe="1200万")


@summary('申请试用')
async def post_apply_trial(req, body: ApplyTrialReq) -> Success:
    ip = req.headers.get('x-forwarded-for')
    log.info(f"apply_trial x-forwarded-for:{ip}, req.ip:{req.ip}, "
             f"REMOTE_ADDR:{req.headers.get('remote_addr')}")
    if not ip:
        ip = req.headers.get('remote_addr') or req.ip
    name = body.name
    email = body.email
    company = body.company
    phone = body.phone
    product = body.product
    log.info(f"apply_trial {name}, {email}, {company}, {phone},{product}")
    return await apply_trial_service(name, email, company, phone, product, ip)
